/* RoombaLib Nov 2012 - Ralf Stoffels
 * 
 * The library contains basic control API for Roomba Vaccum Cleaner robots
 * controlled by an Arduino-Board.
 * It is based on the the Arduino example in the book "Hacking Roomba"
 * In order to reserve the serial interface for communication with the PC
 * this library uses regular IO Pins. This function is provided by the 
 * library "NewSoftSerial" of Mikal Hart (http://arduiniana.org/libraries/newsoftserial/)
*/

#include <NewSoftSerial.h>

#define LEFT 2;
#define RIGHT 1;
#define C 36
#define C_ 37
#define D 38
#define D_ 39
#define E 40
#define F 41
#define F_ 42
#define G 43
#define G_ 44
#define A 45
#define A_ 46
#define H 47
#define P_ 0

int rxPin_nss = 2; // define which pins are for "receive", "transmit" and "data detect"
int txPin_nss = 3;
int ledPin = 13;  // define which pin will have an LED connected to it for simple status

// define "sciSerial" as a NewSoftSerial serial port on those pins
NewSoftSerial sciSerial(rxPin_nss,txPin_nss); 
                                            
// This is the Arduino-Function which is executed first
// NOTE: all Arduino sketches must have a "setup" function
void setup() { 
 
  Serial.begin(9600); 
  roombaInit();
/*  goDistance(500);
  turnRight(45);
  goDistance(300);
  turnRight(45);
  goDistance(300);
  turnLeft(90);  
  goDistance(-500); 
  defineSong(0, 9, ralfSong);
  playSong(0); */
  
  note(G,3,4);
  note(G,3,4);
  note(G,3,8);
  note(A,3,8);
  note(G,3,8);
  note(F,3,8);
  note(E,3,4);
  note(E,3,4);
  note(E,3,4);
  note(P_,3,4);
  note(F,3,4);
  note(F,3,4);
  note(F,3,8);
  note(G,3,8);
  note(F,3,8);
  note(E,3,8);
  note(D,3,4);
  note(D,3,4);
  note(D,3,4);
  note(P_,3,4);
  note(C,3,4);
  note(D,3,4);
  note(E,3,4);
  note(F,3,4);
  note(G,3,8);
  note(A,3,8);
  note(G,3,8);
  note(A,3,8);
  note(G,3,2);
  note(C,4,4);
  note(G,3,4);
  note(G,3,8);
  note(A,3,8);
  note(G,3,8);
  note(F,3,8);
  note(E,3,4);
  note(D,3,4);
  note(G,3,2);
  note(C,4,4);
  note(G,3,4);
  note(G,3,8);
  note(A,3,8);
  note(G,3,8);
  note(F,3,8);
  note(E,3,4);
  note(D,3,4);
  note(C,3,4);

  goDistance(500);
  delay(100);
  goDistance(-500);

  roombaSleep();
} 

// The loop is not used - just flashing the Arduino-LED
void loop() {  // NOTE: all Arduino sketches must have a "loop" function
  digitalWrite(13, HIGH); // turn on LED to say we're starting loop
  delay(2000);  
  digitalWrite(13, LOW); // turn on LED to say we're starting loop
  delay(2000);
}

//=================================================================
// Now here is where we define all of those other things we've used

void roombaInit(){
  int ddPin = 4;

  pinMode(ledPin, OUTPUT);    // set the mode of the pin "ledPin"
  pinMode(ddPin,  OUTPUT);    // set the mode of the pin "ddPin"
  sciSerial.begin(57600);    // set the baud rate of the port "sciSerial"
                              // (defined above)
  
  digitalWrite(ledPin, HIGH); // turn on the LED to say we're alive
  
  // wake up the robot by flashing the "data detect" pin
  digitalWrite(ddPin, HIGH);
  delay(100);
  digitalWrite(ddPin, LOW);
  delay(500);
  digitalWrite(ddPin, HIGH);
  delay(2000);
  
  // set up the Roomba OI to receive commands (see OI manual)
  sciSerial.print(128, BYTE);  // START (always first command)
  delay(50);
  sciSerial.print(130, BYTE);  // CONTROL (same as "Safe Mode")
  delay(50);
  
  // turn off the LED to confirm that we're done setting up Roomba
  digitalWrite(ledPin, LOW);
  delay(100);
}

void roombaSleep() {
  sciSerial.print(133, BYTE);  // POWER (back to passive Mode)
}  


void findCharger() {
  sciSerial.print(143,BYTE); // Roomba tries to find its dock
}

void brushesON() {
  sciSerial.print(138, BYTE); // Roomba's MOTOR
  sciSerial.print(255,BYTE); // Velocity high byte, HEX 00
}

void brushesOFF() {
  sciSerial.print(138, BYTE); // Roomba's MOTOR command
  sciSerial.print(0,BYTE); // Velocity high byte, HEX 00
}

void goDistance(int mm) {   // Distance in mm, >0 foreward move, <0 backward move
  int drivetime;
  drivetime = abs(5*mm);      //time in ms 
  if (mm > 0) goForward();
  else goBackward();
  delay(drivetime);
  stopMoving();
}

void turnLeft(int degrees) {
  float ftime;
  int drivetime;
  ftime = (float)degrees/360*4000;      //time in ms 
  drivetime = (int)ftime;
  spinLeft();
  delay(drivetime);
  stopMoving();
}

void turnRight(int degrees) {
  float ftime;
  int drivetime;
  ftime = (float)degrees/360*4000;  //time in ms 
  drivetime = (int)ftime;
  spinRight();
  delay(drivetime);
  stopMoving();
}
   
void goForward() {
  sciSerial.print(137, BYTE); // Roomba's DRIVE command
  sciSerial.print(0x00,BYTE); // Velocity high byte, HEX 00
  sciSerial.print(0xc8,BYTE); // Velocity low byte,  HEX C8 (00C8=200mm/sec)
  sciSerial.print(0x80,BYTE); // Radius high byte,   HEX 80
  sciSerial.print(0x00,BYTE); // Radius low byte,    HEX 00 (8000=straight)
}

void goBackward() {
  sciSerial.print(137, BYTE); // Roomba's DRIVE command
  sciSerial.print(0xff,BYTE);
  sciSerial.print(0x38,BYTE); // Velocity FF38 = -200 mm/sec (backwards)
  sciSerial.print(0x80,BYTE);
  sciSerial.print(0x00,BYTE); // Radius 8000 = go straight
}

void spinLeft() {
  sciSerial.print(137, BYTE); // Roomba's DRIVE command
  sciSerial.print(0x00,BYTE);   
  sciSerial.print(0xc8,BYTE); // Velocity of spin 00C8 = 200 mm/sec
  sciSerial.print(0x00,BYTE);
  sciSerial.print(0x01,BYTE); // Radius 0001 = spin left
}

void spinRight() {
  sciSerial.print(137, BYTE); // Roomba's DRIVE command
  sciSerial.print(0x00,BYTE);
  sciSerial.print(0xc8,BYTE); // Velocity of spin 00C8 = 200 mm/sec
  sciSerial.print(0xff,BYTE);
  sciSerial.print(0xff,BYTE); // Radius FFFF = spin right
}

void stopMoving() {
  sciSerial.print(137, BYTE); // Roomba's DRIVE command
  sciSerial.print(0x00,BYTE);
  sciSerial.print(0x00,BYTE); // Velocity 0000 = stopped
  sciSerial.print(0x00,BYTE);
  sciSerial.print(0x00,BYTE); // Radius 0000 = nothing
}

int Bump() {
  char sensorbytes[10];  // define a 10-byte array for holding sensor data

  sciSerial.print(142, BYTE); // Roomba's SENSORS command
  sciSerial.print(1,   BYTE); // get sensor packet group 1, which is 10
                              // bytes long. This packet group starts with
                              // packet 7, of which the first two bits are
                              // for the bumpleft and bumpright sensors

  delay(64);  // wait for sensor data
  
  // before storing the new sensor data, wipe the old sensor data
  char i = 0;                  // start at position 0 in the array
  while (i < 10) {             // do a loop until i=10
    sensorbytes[i++] = 0;      // set the byte to 0 and then increment
                               // the loop counter
  } // this bracket is the end of the "wipe data" loop
  
  // go back to position 0 to prepare to receive the new data
  i=0;
  
  // this is the loop to actually read the incoming data and store it
  while(sciSerial.available()) {  // start the loop - check if there is
                                  // data coming in,
    int c = sciSerial.read();     // read it and store the current
                                  // byte as "c"
    
       // error routine to flash the LED 5 times if c= -1
       // (this shouldn't happen)
       if( c==-1 ) {
         for( int i=0; i<5; i ++ ) {    // loop to flash LED 5 times
           digitalWrite(ledPin, HIGH);
           delay(50);
           digitalWrite(ledPin,  LOW);
           delay(50);
      } 
    } 
    
    // since we've read a byte, save it in the sensorbytes array at
    // position "i", and then increment "i"
    sensorbytes[i++] = c;
  } 
  
  if (sensorbytes[0] & 0x01) return RIGHT
  else
  if (sensorbytes[0] & 0x02) return LEFT
  else
  return 0;
}  

void note(char noteID, int octave, int noteLength) {
  // Note ID can be "A" ... "G" or "a" ... "g" for half notes
  // NoteLength specifies the fraction if a full note e.g. 16 means 1/16
  int duration;
  int noteCode;

  if (octave<1) octave=1;
  if (octave>7) octave=7; 
  
  noteCode=noteID+(octave-1)*12; // Note "C" in octave 1 has the code 36
  
  duration = 2048 / noteLength;
  
  if (noteID!=0) {
     sciSerial.print(140, BYTE); // Roomba's SONG command
     sciSerial.print(15,BYTE);
     sciSerial.print(1,BYTE);
     sciSerial.print(noteCode,BYTE);
     sciSerial.print(duration/16,BYTE);
     sciSerial.print(141, BYTE); // Roomba's PLAY command
     sciSerial.print(15, BYTE);
  } 
  delay(duration+50);
  
  Serial.println(noteCode);
}


//===================================================================
// Deutsche Programmierschnittstelle für Kinder und andere Einsteiger

void wachAuf() {
}

void fahrStrecke() {
}

void rechts() {
}

void links() {
}

void vor() {
}

void zurueck() {
}  

void rotiereLinks(){
}

void rotiereRechts(){
}

void schlafEin() {
}

int wand() {
}

