/* RoombaLib Nov 2012 - Ralf Stoffels
 * 
 * The library contains basic control API for Roomba Vaccum Cleaner robots
 * controlled by an Arduino-Board.
 * It is based on the the Arduino example in the book "Hacking Roomba"
 * In order to reserve the serial interface for communication with the PC
 * this library uses regular IO Pins. This function is provided by the 
 * library "NewSoftSerial" of Mikal Hart (http://arduiniana.org/libraries/newsoftserial/)
*/

#ifndef rommbaRS_h
#define roombaRS_h

#include "NewSoftSerial.h"

#define LEFT 2;
#define RIGHT 1;
#define C 36
#define C_ 37
#define D 38
#define D_ 39
#define E 40
#define F 41
#define F_ 42
#define G 43
#define G_ 44
#define A 45
#define A_ 46
#define H 47
#define P_ 0

class roombaRS
{
  public:
    roombaRS();
    void roombaSleep();
    void findCharger();
    void brushesON();
    void brushesOFF();
    void goDistance(int cm);
    void turnLeft(int degrees);
    void turnRight(int degrees);
    void goForward();
    void goBackward();
    void spinLeft();
    void spinRight();
    void stopMoving();
    int Bump();
    void note(char noteID, int octave, int noteLength);

	void fahrStrecke();
    void rechts();
    void links();
    void vor();
    void zurueck();  
    void rotiereLinks();
    void rotiereRechts();
    void schlafEin();
    int wand();
    void suchLader();

	private:
	  int rxPin_nss; // define which pins are for "receive", "transmit" and "data detect"
      int txPin_nss;
      int ledPin;  // define which pin will have an LED connected to it for simple status
	  NewSoftSerial sciSerial;  // alternative serial port based on regular IO pins
}

#endif