<?php

/***************************************************************
* 
* FORM-Plugin für moziloCMS.
* 
* Ralf Stoffels - 2013
*
*
*   getContent($value)
*       -> gibt die HTML-Ersetzung der Plugin-Variable zurück
*   getConfig()
*       -> gibt die Konfigurationsoptionen als Array zurück
*   getInfo()
*       -> gibt die Plugin-Infos als Array zurück
* 
***************************************************************/

session_start();

class FORM extends Plugin {

    function getContent($value) {

    global $CONTENT_DIR_REL;
	global $CAT_REQUEST;

	$values = explode(",", $value);   // Aufteilen eine Liste von kommaseparierten Parametern
	$dir = "./kategorien/".$CAT_REQUEST."/dateien/";
	
	if ($values[0]=="BUTTON") {
		$buttonText = $values[1];    // Anzeige Text des Buttons
		$buttonScript = $values[2];  // Das auszuführende Skript
		$xPos = $values[3];
		$yPos = $values[4];
		$toolTip = $values[5];
		$inputStyle = "";
		if ((yPos != "") && (xPos != "")) $inputStyle = "style=\"position:absolute; top:".$yPos."px; left:".$xPos."px;\"";
		
       	return ("<input ".$inputStyle." type=\"button\" name=\"".$buttonText."\" value=\"".$buttonText."\" title=\"".$toolTip."\" onclick=\"window.location.href = '".$dir.$buttonScript."'\">"); 
	}
		
	if ($values[0]=="INPUT") {
		$inputID = $values[1];
     	$inputText = $values[2];
		$inputSize = $values[3];
		$inputMaxLen = $values[4];
		$xPos = $values[5];
		$yPos = $values[6];
		$minVal = $values[7];
		$maxVal = $values[8];
		$toolTip = $values[9];
		$inputStyle = "";
		if ((yPos != "") && (xPos != "")) $inputStyle = "style=\"position:absolute; top:".$yPos."px; left:".$xPos."px; width:".$inputSize."px \"";

		$inputValue = $_SESSION[$inputID];
		$HTML = $inputText."<input ".$inputStyle." name=\"".$inputID."\" type=\"text\" title=\"".$toolTip."\"";
		$HTML .= "maxlength=\"".$inputMaxLen."\" ";
		$HTML .= "value=\"".$inputValue."\" ";
		$HTML .= "onblur=\"storeVariable(this,'".$inputID."',this.value,'".$minVal."','".$maxVal."')\">";
		  // StoreVariable ist ein JavaScript, das in FORM|BEGIN auf der Seite angelegt wird.
		  // Es ruft ein PHP Skript, das eine Session variable anlegt, die den Wert des Eingabefeldes speichert.
		return($HTML);
        }
		
	if ($values[0]=="SELECT") {
		$selectID = $values[1];
		$selectSize = $values[2];
		$xPos = $values[3];
		$yPos = $values[4];
		$inputStyle = "";
		if ((yPos != "") && (xPos != "")) $inputStyle = "style=\"position:absolute; top:".$yPos."px; left:".$xPos."px;\"";

		$selectValue = $_SESSION[$selectID];
		$HTML = "<select ".$inputStyle." name=\"".$selectID."\" size=\"".$selectSize."\"\n";
        $HTML .= "onblur=\"storeVariable(this,'".$selectID."',this.options[this.selectedIndex].value,'','')\">";
		for ($i=5; $i< count($values); $i++) {
		   if ($values[$i]==$selectValue) $HTML .= "<option selected>".$values[$i]."</option> \n";
		   else
		   $HTML .= "<option>".$values[$i]."</option> \n";
		}
        $HTML .= "</select>";	
        return($HTML);		
	}

	if ($values[0]=="SELECTLIST") {
		$selectID = $values[1];
		$selectSize = $values[2];
		$xPos = $values[3];
		$yPos = $values[4];
		$fileName = $values[5];
		$toolTip = $values[6];
		
		$inputStyle = "";
		if ((yPos != "") && (xPos != "")) $inputStyle = "style=\"position:absolute; top:".$yPos."px; left:".$xPos."px;\"";

		$handle = fopen($dir.$fileName, "r");
				
		$selectValue = $_SESSION[$selectID];
		$HTML = "<select ".$inputStyle." name=\"".$selectID."\" size=\"".$selectSize."\" title=\"".$toolTip."\"\n";
        $HTML .= "onblur=\"storeVariable(this,'".$selectID."',this.options[this.selectedIndex].value,'','')\">";
		while (($buffer = fgets($handle, 100)) !== false) {
		   if ($buffer[strlen($buffer)-1] < '0') $buffer = substr($buffer,0,strlen($buffer)-1);  
		   if ($buffer[strlen($buffer)-1] < '0') $buffer = substr($buffer,0,strlen($buffer)-1);  // 2x um Windows CR+LF abzufangen
		   if ($buffer == $selectValue) {
		      $HTML .= "<option selected>".$buffer."</option> \n";
			}  
		   else $HTML .= "<option>".$buffer."</option> \n";
		}
        $HTML .= "</select>";	
		
		fclose($handle);
        return($HTML);		
	}
	
	if ($values[0]=="RADIO") {
		$radioID = $values[1];
		$xPos = $values[2];
		$yPos = $values[3];
		$inputStyle = "";

		$HTML = "<div>";
   		if ((yPos != "") && (xPos != "")) $HTML = "<div style=\"position:absolute; top:".$yPos."px; left:".$xPos."px; background-color:transparent; background:none; \">\n";

		for ($i=4; $i< count($values); $i++) {
			$HTML .= "<input type=\"radio\" name= \"".$radioID."\" value=\"".$values[$i]."\">".$values[$i]."<br> \n";
		}   
		$HTML .= "</div>";
        return($HTML);		
	}
		
	if ($values[0]=="DISPLAY") {
		$variableName = $values[1];
		$xPos = $values[2];
		$yPos = $values[3];
		$HTML = "<div>";
   		if ((yPos != "") && (xPos != "")) $HTML = "<div style=\"background-color:transparent; background:none; position:absolute; top:".$yPos."px; left:".$xPos."px;\">\n";
        $HTML .= $_SESSION[$variableName]."</div>";
		return($HTML);
	}
	
	if ($values[0]=="PLOT") {
	
		$variableName = $values[1];
		$xPos = $values[2];
		$yPos = $values[3];
		$xSize = $values[4];
		$ySize = $values[5];
		$Attrib = $values[6];
		
		$xValues = $_SESSION[$variableName."_x"];  // Namenskonvention: varname_x speichert die x-Werte
		$yValues = $_SESSION[$variableName."_y"];  // Namenskonvention: varname_y speichert die y-Werte
		
		$HTML = "<div style=\"background-color:transparent; background:none; border-color:transparent; position:absolute; top:".$yPos."px; left:".$xPos."px;\">\n";
		$HTML .= "<svg width=\"".$xSize."\" height=\"".$ySize."\">\n";
		$HTML .= "<rect x=\"0\" y=\"0\" width=\"".$xSize."\" height=\"".$ySize."\" stroke=\"#000\" stroke-width=\"1px\" fill=\"#ffffff\"></rect>\n";
        if ($Attrib == "GRID") {     // Gitter anzeigen
		   for ($i=20; $i < $xSize; $i += 20) {
		      $HTML .= "<line x1=\"".$i."\" y1=\"1\" x2=\"".$i."\" y2=\"".$ySize."\" stroke=\"#4c4b84\" stroke-width=\"0.3\" />\n";
			}
		   for ($i=20; $i < $ySize; $i += 20) { 
		      $HTML .= "<line y1=\"".$i."\" x1=\"1\" y2=\"".$i."\" x2=\"".$xSize."\"stroke=\"#4c4b84\" stroke-width=\"0.3\" />\n";
			}
		}
		$count = count($xValues);
		$maxX = 0;  $minX = $xValues[0];
		for($i=0; $i<$count; $i++) {
			if (is_numeric($xValues[$i])) {
				if ($xValues[$i] > $maxX) $maxX = $xValues[$i];   // Den größten x-Wert finden um zu skalieren
				if ($xValues[$i] < $minX) $minX = $xValues[$i];   //	Den kleinsten x-Wert finden um zu skalieren	   
			}	
		}
	
		if (abs($maxX-$minX) >0.00001) $Scaler = $xSize/($maxX-$minX);
		else $Scaler = 1;
		$color = "#000";
		
		for($i=0; $i<$count-1; $i++) {
			if (is_numeric($xValues[$i+1])) {
				$xPix = ($xValues[$i]-$minX) * $Scaler;
				$yPix = $ySize/2 - ($yValues[$i] * $Scaler);
				$xPixNext = ($xValues[$i+1]-$minX) * $Scaler;
				$yPixNext = $ySize/2- ($yValues[$i+1] * $Scaler);
				$HTML .= "<line y1=\"".$yPix."\" x1=\"".$xPix."\" y2=\"".$yPixNext."\" x2=\"".$xPixNext."\"stroke=\"".$color."\" stroke-width=\"1\" />\n";
			} else	{
				switch($xValues[$i+1]) {
				case "Black": 
					$color = "black";
					break;
				case "Red":
					$color = "red";
					break;
				case "Green":
					$color = "green";
					break;
				case "Blue":
					$color = "blue";
					break;
				}
				$i++;   // Einen Wert überspringen, da darin ja die Farbe kodiert war;
			}	
		}
		
		$HTML .= "</svg> </div>";
		return($HTML);
	}

        if ($values[0] == "FUNCTION") {
		$returnText="";
		$functionName = $values[1];
		if (function_exists($functionName)) {
			$err = $functionName();    // toll: So ruft PHP eine Funktion, deren Name in der Variable steht.
			if ($err!="") $returnText ="<span style=\"color:red;font-size:100%\"> ".$err." </span>";
		} else $returnText ="<span style=\"color:red;font-size:100%\"> FEHLER in FORM|FUNCTION: Funktion existiert nicht </span>";
		return($returnText);  
	} 
		
	if ($values[0]=="BEGIN") {    // Dieses Element muss am Anfang des Formulars eingebaut werden und nimmt die Inputwerte entgegen und sendet sie zum PHP 
		$HTML = "<script language=\"javascript\" type=\"text/javascript\">\n"; 
		$HTML .= "function storeVariable(feld,variableName, variableValue, min, max) {\n";
		$HTML .= "if (window.XMLHttpRequest) xmlhttp=new XMLHttpRequest();\n";
		$HTML .= "else xmlhttp=new ActiveXObject(\"Microsoft.XMLHTTP\");\n";
		$HTML .= "if (((variableValue >= parseFloat(min)) && (variableValue<=parseFloat(max))) || (min==\"\") || (max==\"\")) {\n";
		$HTML .= "  xmlhttp.open(\"GET\",\"./plugins/FORM/storeVariable.php?variableName=\"+variableName+\"&variableValue=\"+variableValue,true);\n";
		$HTML .= "  xmlhttp.send(); \n";
		$HTML .= "} else {\n";
		$HTML .= "   alert(\"Bereichsüberschreitung!   Erlaubter Bereich: \"+min+\" .. \"+max);\n";
		$HTML .= "   feld.focus();\n";
        $HTML .= "}\n }\n";
		$HTML .= "</script>\n";
					
		$backgroundPicture = $values[1];
		if ($backgroundPicture != "") {
			$HTML .= "<form style = \"";
			$HTML .= "background-image:url(".$dir.$backgroundPicture."); padding:0px; width:833px; overflow:hidden; border:1px solid #ddd;\">";
		} else {
			$HTML .= "<form>\n";
		}  
			
		if ($values[2] != "") {   // hier kann eine PHP-Dateil mit eingebunden werden, deren Funktionen dann benutzt werden können	
			$PHPFileName = $values[2];
			if(is_file($dir.$PHPFileName)) {
				require_once($dir.$PHPFileName);  // Datei wird nur beim ersten Aufruf eingebunden.
			} else 	$HTML="FEHLER in FORM|BEGIN: PHP Datei nicht gefunden";
        }
     		
		return($HTML);    
	}   

	if ($values[0]=="END") {
	    return("</form>");
	} 
		
	return("Falsche Syntax");
    
    } // function getContent
    
    
    
    /***************************************************************
    * 
    * Gibt die Konfigurationsoptionen als Array zurück.
    * Ist keine Konfiguration nötig, ist dieses Array leer.
    * 
    ***************************************************************/
    function getConfig() {
        global $ADMIN_CONF;
        $language = $ADMIN_CONF->get("language");

        /***************************************************************
        * 
        * Details (Beispiele folgen weiter unten):
        * 
        * Die Funktion liefert ein Array zurück. Dieses enthält die 
        * Eingabefelder, mit denen der User im moziloAdmin Einstellungen 
        * am Plugin vornehmen kann.
        * Der "type"-Parameter der Eingabefelder bestimmt, um welche Art 
        * Eingabefeld es sich handelt und ist Pflicht. Folgende Werte
        * stehen zur Verfügung:
        *   text            Textfeld (beliebiger Text)
        *   textarea        mehrzeilige Texteingabe
        *   password        Passwortfeld (Anzeige des Inhalts als ***)
        *   checkbox        Checkbox (ja/nein)
        *   radio           Radio-Buttons (entweder/oder)
        *   select          Auswahlliste
        * 
        * Die Werte der Eingabefelder werden in die plugin.conf des 
        * Plugins geschrieben - der Name des Eingabefelds ist dabei der 
        * Schlüssel in der plugin.conf (siehe Beispiele).
        * 
        ***************************************************************/
        
        
        // Rückgabe-Array initialisieren
        // Das muß auf jeden Fall geschehen!
        $config = array();
        
        # nur eine Sprache ---------------------------------
        
        /***************************************************************
        * Beispiel: Normales Textfeld, beliebige Eingaben
        * - das Textfeld heißt "texteingabe"; gibt der Benutzer "abc" 
        *   ein und speichert die Plugin-Einstellungen, wird in der 
        *   plugin.conf folgende Zeile angelegt bzw. überschrieben:
        *   texteingabe = abc 
        ***************************************************************/
        
        $config['texteingabe']  = array(
            "type" => "text",                           // Pflicht:  Eingabetyp
            "description" => "Bitte Wert eingeben",     // Pflicht:  Beschreibung
            "maxlength" => "100",                       // optional: maximale Länge
            "size" => "30",                             // optional: dargestellte Zeichen
            "regex" => "/^[a-z]{3}$/",                   // optional: Erlaubte Werte als regulärer Ausdruck (hier: drei kleine Buchstaben; wird beim Speichern der Einstellungen überprüft)
            "regex_error" => "Die Eingabe muss genau 3 kleine Buchstaben enthalten." // optional: Fehlermeldung für die RegEx-Überprüfung
        );

            
        /***************************************************************
        * Beispiel: Mehrzeiliges Textfeld, beliebige Eingaben
        ***************************************************************/
            
        $config['mehrzeiligertext'] = array(
            "type" => "textarea",                       // Pflicht:  Eingabetyp 
            "cols" => "30",                             // Pflicht:  Spaltenanzahl 
            "rows" => "5",                              // Pflicht:  Zeilenanzahl
            "description" => "Bitte Text eingeben",     // Pflicht:  Beschreibung
            "regex" => "/^.+$/"           ,             // optional: Erlaubte Werte als regulärer Ausdruck (hier: wenigstens ein Zeichen; wird beim Speichern der Einstellungen überprüft)
            "regex_error" => "Die Eingabe darf nicht leer sein." // optional: Fehlermeldung für die RegEx-Überprüfung
        );

            
        /***************************************************************
        * Beispiel: Passwortfeld, beliebige Eingaben
        ***************************************************************/
        
        $config['passwort']  = array(
            "type" => "password",                       // Pflicht:  Eingabetyp
            "saveasmd5" => "true",                      // Pflicht:  soll das Passwort MD5-verschlüsselt in der plugin.conf abgelegt werden? (true/false)
            "description" => "Bitte Passwort eingeben", // Pflicht:  Beschreibung
            "maxlength" => "100",                       // optional: maximale Länge
            "size" => "30",                             // optional: dargestellte Zeichen
            "regex" => "/^.*(?=.{8,})(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).*$/", // optional: Erlaubte Werte als regulärer Ausdruck (hier: mindestens acht Zeichen, bestehend aus Klein- und Großbuchstaben sowie Ziffern); wird beim Speichern der Einstellungen überprüft
            "regex_error" => "Das Passwort muss aus mindestens acht Zeichen bestehen, Klein- und Großbuchstaben sowie Ziffern enthalten." // optional: Fehlermeldung für die RegEx-Überprüfung
        );

            
        /***************************************************************
        * Beispiel: Checkbox (aktiv oder nicht aktiv)
        ***************************************************************/
        
        $config['janeinoption'] = array(
            "type" => "checkbox",                       // Pflicht:  Eingabetyp 
            "description" => "Ja oder nein?"            // Pflicht:  Beschreibung
        );

        
        /***************************************************************
        * Beispiel: Radio-Buttons (entweder oder)
        ***************************************************************/
        
        $config['entwederoder'] = array(
            "type" => "radio",                          // Pflicht:  Eingabetyp
            "description" => "Welche Farbe?",           // Pflicht:  Beschreibung
            // Pflicht: Beschreibung der einzelnen Auswahlmöglichkeiten
            // entweder so...
            "descriptions" => array(
                "blau",                 // "blau" wird sowohl angezeigt als auch in die plugin.conf gespeichert
                "rot",
                "gruen"
                )
            // ..oder so:
/*
            "descriptions" => array(
                "blau" => "Blau",       // angezeigt wird "Blau", in die plugin.conf gespeichert wird "blau"
                "rot" => "Rot",
                "gruen" => "Grün"
                )
*/
        );
        
        
        /***************************************************************
        * Beispiel: Auswahlliste (Einzel- oder Mehrfachauswahl)
        ***************************************************************/
            
        $config['auswahl'] = array(
            "type" => "select",                         // Pflicht:  Eingabetyp
            "description" => "Ich mache Urlaub in...",  // Pflicht:  Beschreibung
            // Pflicht:  Beschreibung der einzelnen Auswahlmöglichkeiten
            // entweder so...
            "descriptions" => array(
                "Australien",           // "Australien" wird sowohl angezeigt als auch in die plugin.conf gespeichert
                "Venezuela",
                "Chemnitz"
                ),
            // ...oder so:
/*
            "descriptions" => array(
                "aus" => "Australien",  // angezeigt wird "Australien", in die plugin.conf gespeichert wird "aus"
                "ven" => "Venezuela",
                "che" => "Chemnitz"
                ),
*/
            "multiple" => "true"                        // optional: Mehrfachauswahl erlauben
        ); 

        // Nicht vergessen: Das gesamte Array zurückgeben
        return $config;
        
        // Aber halt, alle Optionen wären dann ja in Deutsch - auch für User, die eine andere 
        // Sprache im Admin eingestellt haben!

        // Man kann die Optionen auch in verschiedenen Sprachen beschreiben; 
        // angezeigt wird dann die, die im Admin eingestellt ist (z.B. deDE oder enEN).
        
        // Dafür muß jede Beschreibung natürlich für verschiedene Sprachen verfügbar sein;
        // hier das Beispiel von zwei Optionen jeweils in Deutsch und Englisch:

        $config['deDE']['janeinoption'] = array(
            "type" => "checkbox",
            "description" => "Ja oder nein?"
        );
        $config['deDE']['texteingabe']  = array(
            "type" => "text",
            "description" => "Bitte Wert eingeben",
            "maxlength" => "100",
            "size" => "30",
            "regex" => "/^[a-z]{3}$/",
            "regex_error" => "Die Eingabe muss genau 3 kleine Buchstaben enthalten."
        );
        
        $config['enEN']['janeinoption'] = array(
            "type" => "checkbox",
            "description" => "Yes or no?"
        );
        $config['enEN']['texteingabe']  = array(
            "type" => "text",
            "description" => "Please enter a value",
            "maxlength" => "100",
            "size" => "30",
            "regex" => "/^[a-z]{3}$/",
            "regex_error" => "Your input has to consist of exactly three small letters."
        );
            
        // Jetzt wird das Optionen-Array in der aktuell verwendeten Sprache zurückgegeben. 
        if(isset($config[$language])) {
            return $config[$language];
        }
        // Stellt das Plugin diese Sprache nicht zur Verfügung, werden die englischen Optionen zurückgegeben.
        else {
            return $config['enEN'];
        }
    } // function getConfig    
    
    
    /***************************************************************
    * 
    * Gibt die Plugin-Infos als Array zurück - in dieser 
    * Reihenfolge:
    *   - Name und Version des Plugins
    *   - für moziloCMS-Version
    *   - Kurzbeschreibung
    *   - Name des Autors
    *   - Download-URL
    *   - Platzhalter für die Selectbox
    * 
    ***************************************************************/
    function getInfo() {
        global $ADMIN_CONF;
        $language = $ADMIN_CONF->get("language");
        # nur eine Sprache ---------------------------------
        $info = array(
            // Plugin-Name + Version
            "<b>FORM</b>",
            // moziloCMS-Version
            "1.12",
            // Kurzbeschreibung nur <span> und <br /> sind erlaubt
            "Plugin zum Erstellen von Forms",
            // Name des Autors
            "Ralf Stoffels",
            // Download-URL
            "http://cms.mozilo.de",
            // Platzhalter für die Selectbox in der Editieransicht 
            // - ist das Array leer, erscheint das Plugin nicht in der Selectbox
            array(
                '{FORM}' => 'Kurzbeschreibung',
                '{FORM|}' => 'Kurzbeschreibung'
            )
        );
        // Rückgabe der Infos.
        // Auch hier könnte man die Inhalte natürlich von der aktuell im Admin eingestellten 
        // Sprache abhängig machen - siehe getConfig().
        return $info;
        
    } // function getInfo

} // class DEMOPLUGIN

?>
