;=============================================================
;    Textausgabe per Serial und bitbanging
;    Ohne CTC mit kalibrierter Schleife
;    Ein bit is 104us breit
;    9600Bd 1 startbit 1 Stoppbit high
;=============================================================
        ORG	0000H

	ld	sp,$FFF0    ;set stack pointer
	call	ser.begin

LOOP:	ld 	B,$41
	call 	ser.writebyte
	call	ser.bytedelay
	jp	LOOP


;============================================================
;      Functions
;============================================================

;========= Delay 104us = 1 bit at 9600bd =======
ser.bitdelay:	ld	B,$1B
ser.j1:		dec	B
		jp 	NZ,ser.j1
		ret

;========= Delay between two bytes ============
ser.bytedelay:  ld      B,$FF
ser.j0:        	dec     B
        	jp      NZ,ser.j0
		ret

;======== Serial Begin ========================
ser.begin:	ld A,$01
		out ($00),A
		call ser.bytedelay
		call ser.bytedelay
		ret

;======= Write byte  ==========================
;  B=byte to send
;  Output pin #1
;==============================================
ser.writebyte:	ld 	C,$00		;set C = output port adress
		ld 	D,$00
		out	(C),D
		call 	ser.bitdelay    ;send startbit =0

		ld 	A,$01		;set test to LSB
ser.loop1:	and	B
		jp	Z,ser.j2
		ld	D,$01
		jp 	ser.j3
ser.j2:		ld	D,$00
ser.j3:		out	(C),D
		call	ser.bitdelay
		sla	A               ;shift the test one bit up
		jp	NC,ser.loop1
		ld 	D,$01           ;set output back to 1
		out	(C),D
		ret
		
		END
