class MillVectorList {
  ArrayList<MillVector> Coordinates;
  int cmdIndex;
  int vectorIndex;    // Index des aktuellen Vectors (wird mit Laden einer neuen datei doer rewind() zurückgesetzt
  float lastX, lastY; // Speichert die vorherigen absoluten Koordinaten (wird zur Berechnung der relativen Koordinaten gebraucht)
  
  float PLT_SCALE = 0.025;   //passend für Inkscape
    
  MillVectorList() {      // Konstruktor
    Coordinates = new ArrayList<MillVector>();
    vectorIndex = 0;
    lastX = 0;
    lastY = 0;
  }
  
  void loadPLT(String path, float stepsProMM) {
     StringList commands;
     MillVector vec,point;
     byte[] rawFile;
     boolean ende;
     String cmd, opCode;
     String[] pieces;
     float x,y;
     boolean down;
     boolean newCoordAvailable;
     float minX, minY;
     
     PLT_SCALE = 1 / stepsProMM;
     cmdIndex = 0;
     vectorIndex = 0;
     ende = false;
     rawFile=loadBytes(path);
     commands = new StringList();   // Enthält die Liste der PLT Commandos
  
     while ((!ende)&&(cmdIndex<rawFile.length)){   // Liste wird aus dem byte-Array herausgelesen
       ende = true;
       cmd = getNextPLTCommand(rawFile);
       //println("cmd = |",cmd.length(),"|");
       if (cmd != "-") {
         commands.append(cmd);
         ende = false; 
       }
     }
     
     down=false;
     //println(commands.size()," Kommandos");
  
     for (int i=0; i<commands.size(); i++) {  // PLT Coomands nacheinander in mm Koordinaten umrechnen     
       cmd=commands.get(i);
       newCoordAvailable=false;
       x=0; y=0;
       opCode = cmd.substring(0,2);
       print(i,": ",opCode,"   ");
       if (opCode.equals("PD")||opCode.equals("PU")||opCode.equals("PA")) {
         if (cmd.length() > 2) {
             pieces = splitTokens(cmd.substring(2),", ");
             if (pieces.length>1) {
                x = float(pieces[0])*PLT_SCALE;
                y = float(pieces[1])*PLT_SCALE;
                newCoordAvailable = true;
                println(x," , ",y, "   ",opCode);
             }
          }
          if (opCode.equals("PD")) down=true;
          if (opCode.equals("PU")) down=false;
          if (newCoordAvailable) {
             vec = new MillVector(x,y,0,down,0);
             Coordinates.add(vec);
          }   
       }
     }
     vec= new MillVector(0,0,0,false,0);  // Zum Schluss noch einen Vektor anhängen, der den Fräser wieder zurückfährt   
     Coordinates.add(vec);
     
     // Hier wird überprüft, ob negative Werte vorkommen und ggfs. alles verschoben.
     minX=0; minY=0;
     for (int i=0; i<Coordinates.size(); i++) {
       point = Coordinates.get(i);
       if (point.getX() < minX) minX=point.getX();
       if (point.getY() < minY) minY=point.getY();
     }
     if ((minX<0) || (minY<0)) {     // korrigieren
        for (int i=0; i<Coordinates.size(); i++) {
          point = Coordinates.get(i);
          point.setX(point.getX()-minX);
          point.setY(point.getY()-minY);
          Coordinates.set(i,point);
        }
     } 
  }
  
  String getNextPLTCommand(byte b[]) {
    String out = "";

    if (cmdIndex >= b.length) return("-");
    do {
      if ((b[cmdIndex]>=' ')&&(b[cmdIndex]!=';')) out += char(b[cmdIndex]);
      cmdIndex++;
    } while ((cmdIndex<b.length)&&(b[cmdIndex-1]!=';'));
    //println(out);
    if (out.length()>0) return(out); else return("-");
  }

  void plot(int origX, int origY, float scale, float diameter){
    int lastX=0, lastY=0;
    int x,y;
    MillVector point;
    
    for (int i=0; i<Coordinates.size(); i++) {
      point = Coordinates.get(i);
      x = int(point.getX()*scale);
      y = int(point.getY()*scale);
      
      // println(i,": ",x," ; ",y);
      if (point.isDown()) {
        stroke(0);
        strokeWeight(int(scale * diameter));
      } else {
        stroke(0,255,0);
        strokeWeight(1);
      }
      line(lastX+origX, origY-lastY, x+origX, origY-y);
      lastX = x;
      lastY = y;  
    }
    strokeWeight(1);
  }
  
  // Setzt den vector Index wieder auf den Anfang zurück
  void rewind() {
    vectorIndex = 0;
    lastX = 0;
    lastY = 0;
  } 
  
  //Liefert die relativen Fahrkoordinaten in mm als MillVector zurück 
  MillVector getNextVector() {
    MillVector point;
    MillVector vector;
    float dx,dy;
    boolean down;
    
    if(vectorIndex < Coordinates.size()) {
      point = Coordinates.get(vectorIndex);
      dx = point.getX() - lastX;
      dy = point.getY() - lastY;
      lastX = point.getX();
      lastY = point.getY();
      down = point.isDown(); 
      vector = new MillVector(dx, dy, 0, down, 0);
      vectorIndex++;
    } else {
      vector = null;    // Signalisiert, dass das der letze Vector war
    }
    
    return(vector);
  }
  
}
  
