/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CDrawable;
import controlP5.ControlFont;
import controlP5.ControlP5;
import controlP5.ControllerInterface;
import controlP5.ControllerStyle;
import processing.core.PFont;
import processing.core.PGraphics;

public class Label
implements CDrawable {
    protected int _myLetterSpacing = 0;
    protected boolean isMultiline;
    protected boolean isFixedSize;
    protected ControllerStyle _myControllerStyle = new ControllerStyle();
    protected boolean isVisible = true;
    protected int _myColor = -1;
    protected boolean isColorBackground;
    protected boolean isToUpperCase = true;
    protected boolean changed;
    protected int _myColorBackground = -1;
    protected int _myHeight = -1;
    protected int _myWidth = -1;
    protected String _myText = "";
    protected ControlFont _myFontLabel;
    protected int _myLineHeight = 0;
    protected int alignX = 37;
    protected int alignY = 37;
    protected int textAlign = 37;
    public static int paddingX = 4;
    public static int paddingY = 4;
    public int _myPaddingX = paddingX;
    public int _myPaddingY = paddingY;
    protected Labeltype _myLabeltype;
    protected int _myTextHeight = 1;
    protected float offsetYratio = 0.0f;
    private ControlP5 cp5;

    private Label(Label label) {
        this._myText = label.getText();
        this.isToUpperCase = label.isToUpperCase();
        this._myLetterSpacing = label.getLetterSpacing();
        this._myLineHeight = label.getLineHeight();
        this._myFontLabel = label.getFont();
        this._myLabeltype = label.getLabeltype();
    }

    public Label(ControlP5 controlP5, String string) {
        this.init(controlP5, string, 0, 0, this._myColor);
    }

    public Label(ControlP5 controlP5, String string, int n, int n2, int n3) {
        this.init(controlP5, string, n, n2, n3);
    }

    private void init(ControlP5 controlP5, String string, int n, int n2, int n3) {
        this.cp5 = controlP5;
        this._myWidth = n;
        this._myHeight = n2;
        this._myText = string;
        this._myColor = n3;
        this.setLabeltype(new SinglelineLabel());
        this.setFont(this.cp5.controlFont);
        this.setLabeltype(new SinglelineLabel());
        this.set(this._myText);
        this._myControllerStyle = new ControllerStyle();
    }

    Label setLabeltype(Labeltype labeltype) {
        this._myLabeltype = labeltype;
        return this;
    }

    Labeltype getLabeltype() {
        return this._myLabeltype;
    }

    public Label align(int[] nArray) {
        this.alignX = nArray[0];
        this.alignY = nArray[1];
        return this;
    }

    public Label align(int n, int n2) {
        this.alignX = n;
        this.alignY = n2;
        return this;
    }

    public Label alignX(int n) {
        this.alignX = n;
        return this;
    }

    public Label alignY(int n) {
        this.alignY = n;
        return this;
    }

    public int[] getAlign() {
        return new int[]{this.alignX, this.alignY};
    }

    public Label setPadding(int n, int n2) {
        this._myPaddingX = n;
        this._myPaddingY = n2;
        return this;
    }

    public Label setPaddingX(int n) {
        this._myPaddingX = n;
        return this;
    }

    public Label setPaddingY(int n) {
        this._myPaddingY = n;
        return this;
    }

    public void draw(PGraphics pGraphics, int n, int n2, ControllerInterface<?> controllerInterface) {
        if (this.isVisible) {
            this.getLabeltype().draw(this, pGraphics, n, n2, controllerInterface);
        }
    }

    public void draw(PGraphics pGraphics, int n, int n2, int n3, int n4) {
        if (this.isVisible) {
            this.getLabeltype().draw(this, pGraphics, n, n2, n3, n4);
        }
    }

    @Override
    public void draw(PGraphics pGraphics) {
        if (this.isVisible) {
            this._myFontLabel.adjust(pGraphics, this);
            this.draw(pGraphics, 0, 0);
        }
    }

    public void draw(PGraphics pGraphics, int n, int n2) {
        if (this.isVisible) {
            pGraphics.pushMatrix();
            pGraphics.translate((float)this._myControllerStyle.marginLeft, (float)this._myControllerStyle.marginTop);
            pGraphics.translate((float)n, (float)n2);
            if (this.isColorBackground) {
                float f = this.getStyle().paddingRight + this.getStyle().paddingLeft;
                f = this.getStyle().backgroundWidth > -1 ? (f += (float)this._myControllerStyle.backgroundWidth) : (f += (float)this._myFontLabel.getWidth());
                float f2 = this.getStyle().paddingBottom + this.getStyle().paddingTop;
                f2 = this.getStyle().backgroundHeight > -1 ? (f2 += (float)this.getStyle().backgroundHeight) : (f2 += (float)this._myFontLabel.getHeight());
                pGraphics.fill(this._myColorBackground);
                pGraphics.rect(0.0f, 1.0f, f, f2);
            }
            pGraphics.translate((float)this._myControllerStyle.paddingLeft, (float)this._myControllerStyle.paddingTop);
            this._myFontLabel.draw(pGraphics, this);
            pGraphics.popMatrix();
        }
    }

    public Label hide() {
        return this.setVisible(false);
    }

    public Label show() {
        return this.setVisible(true);
    }

    public Label setVisible(boolean bl) {
        this.isVisible = bl;
        return this;
    }

    public Label updateFont(ControlFont controlFont) {
        return this.setFont(controlFont);
    }

    public Label set(String string) {
        return this.setText(string);
    }

    public Label setText(String string) {
        this._myText = string;
        this.setChanged(true);
        return this;
    }

    public Label setFixedSize(boolean bl) {
        this.isFixedSize = bl;
        return this;
    }

    public boolean isFixedSize() {
        return this.isMultiline ? false : this.isFixedSize;
    }

    public String getText() {
        return this._myText;
    }

    public String getTextFormatted() {
        return this.getLabeltype().getTextFormatted();
    }

    public ControllerStyle getStyle() {
        return this._myControllerStyle;
    }

    public Label setWidth(int n) {
        this._myWidth = n;
        this.setChanged(true);
        return this;
    }

    public Label setHeight(int n) {
        this._myHeight = n;
        this.setChanged(true);
        return this;
    }

    public int getWidth() {
        return this._myLabeltype.getWidth();
    }

    public int getHeight() {
        return this._myLabeltype.getHeight();
    }

    public int getOverflow() {
        return this.getLabeltype().getOverflow();
    }

    public Label setMultiline(boolean bl) {
        this.isMultiline = bl;
        this._myLabeltype = this.isMultiline ? new MultilineLabel() : new SinglelineLabel();
        return this;
    }

    public Label toUpperCase(boolean bl) {
        this.isToUpperCase = bl;
        this.setChanged(true);
        return this;
    }

    public ControlFont getFont() {
        return this._myFontLabel;
    }

    public Label setFont(int n) {
        ControlP5.logger.warning("BitFont is now of type PFont, use setFont(PFont) instead.");
        return this;
    }

    public Label setFont(PFont pFont) {
        return this.setFont(new ControlFont(pFont));
    }

    public Label setFont(ControlFont controlFont) {
        this.setLineHeight(controlFont.getSize());
        this._myFontLabel = new ControlFont(controlFont.getFont(), controlFont.getSize());
        this._myFontLabel.init(this);
        this.setChanged(true);
        return this;
    }

    public Label setSize(int n) {
        this._myFontLabel.setSize(n);
        return this;
    }

    protected boolean isChanged() {
        return this.changed;
    }

    protected Label setChanged(boolean bl) {
        this.changed = bl;
        return this;
    }

    Label setTextHeight(int n) {
        this._myTextHeight = n;
        return this;
    }

    public int getTextHeight() {
        return this._myFontLabel.getTextHeight();
    }

    public int getLineHeight() {
        return this._myLineHeight;
    }

    public Label setOffsetY(int n) {
        return this;
    }

    public Label setOffsetYratio(float f) {
        this.offsetYratio = f;
        this.setChanged(true);
        return this;
    }

    public float getOffsetYratio() {
        return this.offsetYratio;
    }

    public Label setLineHeight(int n) {
        this._myLineHeight = n;
        this.setChanged(true);
        return this;
    }

    public Label setColor(int n, boolean bl) {
        this.setColor(n);
        this.setFixedSize(bl);
        return this;
    }

    public Label setColor(int n) {
        this._myColor = n;
        this.setChanged(true);
        return this;
    }

    public int getColor() {
        return this._myColor;
    }

    public Label setColorBackground(int n) {
        this.enableColorBackground();
        this._myColorBackground = n;
        return this;
    }

    public Label disableColorBackground() {
        this.isColorBackground = false;
        return this;
    }

    public Label enableColorBackground() {
        this.isColorBackground = true;
        return this;
    }

    public int getLetterSpacing() {
        return this._myLetterSpacing;
    }

    public Label setLetterSpacing(int n) {
        this._myLetterSpacing = n;
        this.setChanged(true);
        return this;
    }

    public boolean isMultiline() {
        return this.isMultiline;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isToUpperCase() {
        return this.isToUpperCase;
    }

    protected Label copy() {
        return new Label(this);
    }

    class MultilineLabel
    implements Labeltype {
        MultilineLabel() {
        }

        @Override
        public void draw(Label label, PGraphics pGraphics, int n, int n2, int n3, int n4) {
            Label.this._myFontLabel.adjust(pGraphics, label);
            label.draw(pGraphics, n, n2);
        }

        @Override
        public void draw(Label label, PGraphics pGraphics, int n, int n2, ControllerInterface<?> controllerInterface) {
            Label.this._myFontLabel.adjust(pGraphics, label);
            label.draw(pGraphics, n, n2);
        }

        @Override
        public int getWidth() {
            return Label.this._myWidth;
        }

        @Override
        public int getHeight() {
            return Label.this._myHeight;
        }

        @Override
        public int getOverflow() {
            return Label.this._myFontLabel.getOverflow();
        }

        @Override
        public String getTextFormatted() {
            return Label.this.isToUpperCase ? Label.this._myText.toUpperCase() : Label.this._myText;
        }
    }

    class SinglelineLabel
    implements Labeltype {
        SinglelineLabel() {
        }

        private void align(PGraphics pGraphics, int n, int n2, int n3, int n4) {
            int n5 = 0;
            int n6 = 0;
            switch (n) {
                case 3: {
                    n5 = (n3 - Label.this._myFontLabel.getWidth()) / 2;
                    break;
                }
                case 37: {
                    n5 = Label.this._myPaddingX;
                    break;
                }
                case 39: {
                    n5 = n3 - Label.this._myFontLabel.getWidth() - Label.this._myPaddingX;
                    break;
                }
                case 10: {
                    n5 = -Label.this._myFontLabel.getWidth() - Label.this._myPaddingX;
                    break;
                }
                case 11: {
                    n5 = n3 + Label.this._myPaddingX;
                }
            }
            switch (n2) {
                case 3: {
                    n6 = n4 / 2 + Label.this._myFontLabel.getTop() - Label.this._myFontLabel.getCenter();
                    break;
                }
                case 101: {
                    n6 = 0;
                    break;
                }
                case 102: {
                    n6 = n4 - Label.this._myFontLabel.getHeight() - 1;
                    break;
                }
                case 0: {
                    n6 = n4 + Label.this._myFontLabel.getTop() - 1;
                    break;
                }
                case 13: {
                    n6 = n4 + Label.this._myPaddingY;
                    break;
                }
                case 12: {
                    n6 = -Label.this._myFontLabel.getHeight() - Label.this._myPaddingY;
                }
            }
            pGraphics.translate((float)n5, (float)n6);
        }

        @Override
        public void draw(Label label, PGraphics pGraphics, int n, int n2, int n3, int n4) {
            Label.this._myFontLabel.adjust(pGraphics, label);
            pGraphics.pushMatrix();
            this.align(pGraphics, Label.this.alignX, Label.this.alignY, n3, n4);
            label.draw(pGraphics, n, n2);
            pGraphics.popMatrix();
        }

        @Override
        public void draw(Label label, PGraphics pGraphics, int n, int n2, ControllerInterface<?> controllerInterface) {
            this.draw(label, pGraphics, n, n2, controllerInterface.getWidth(), controllerInterface.getHeight());
        }

        @Override
        public int getWidth() {
            return Label.this.isFixedSize ? Label.this._myWidth : Label.this._myFontLabel.getWidth();
        }

        @Override
        public int getHeight() {
            return Label.this._myFontLabel.getHeight();
        }

        @Override
        public int getOverflow() {
            return -1;
        }

        @Override
        public String getTextFormatted() {
            return Label.this.isToUpperCase ? Label.this._myText.toUpperCase() : Label.this._myText;
        }
    }

    class SinglelineTextfield
    extends SinglelineLabel {
        SinglelineTextfield() {
        }

        @Override
        public String getTextFormatted() {
            return Label.this._myText;
        }
    }

    static interface Labeltype {
        public void draw(Label var1, PGraphics var2, int var3, int var4, ControllerInterface<?> var5);

        public void draw(Label var1, PGraphics var2, int var3, int var4, int var5, int var6);

        public int getWidth();

        public int getHeight();

        public int getOverflow();

        public String getTextFormatted();
    }
}

