// PCMill
// Version 0.9
// Datum 2.Dezember 14
// Versionskommentar: 
//----------------------------------------------------------------------------------------------------------------------------
// Kontrollbytes:
// X - X-Motor fährt in positive X-Richtung
// x - X-Motor fährt in negative X-Richtung
// Y - Y-Motor fährt in positive Y-Richtung
// y - Y-Motor fährt in negative Y-Richtung
// Z - Z-Motor fährt in positive Z-Richtung
// z - Z-Motor fährt in negative Z-Richtung
// F - Fräsmotor ein
// f - Fräsmotor aus
// +xxxx - Z-Motor fährt um xxxx Schritte nach oben (xxxx ist eine hex zahl)
// -xxxx - Z-Motor fährt um xxxx Schritte nach unten (xxxx ist eine hex zahl)
// S - Starte den Fräsvorgang (Ab jetzt fordert der Arduino solange Vektoren an, bis das Stoppsignal vom PC kommt)
// s - Stoppe den Fräsvorgang (Typischerweise am Ende der Fräsdatei)
// P - Pause
// C - Continue (Fortsetzen nach Pause)
// % - Fahrgeschwindigkeit setzen (zwei-byte HexZahl)

// Vom Arduino kommend:
// ? - Nächster Vektor wird angefordert

// Vektorformat:
// <XY><sign><StepHex><sign><XaspectHex><sign>YaspectHex>
//                 - Übergibt einen Vector an den Arduino. 
//                   Die drei Vorzeichen geben die Richtung an.
//                   Durch die Angabe von X bzw. Y am Anfang wird festgelegt, auf welche der beiden Achsen sich 
//                   der Masterclock bezieht. Dadurch werden die Winkel genauer.
//                   Die drei Werte sind unsigned Hex (4 Characters).
//                   StepHex - Anzahl der Schritte in X-Richtung
//                   XAspectHex - Alle wieviel Clocks wird ein X-Motorschritt gemacht.
//                   YAspectHex - Alle wieviel Clocks wird ein Y-Motorschritt gemacht.
//                   Beispiel: X+024E+0041-003D
// "##----#----#----" - Keine weiteren Vectoren mehr d.h. Arduino hört auf danach zu fragen.



import controlP5.*;
import processing.serial.*;

//--------- Konstanten ---------------------------
final int X_STEPS_PER_MM = 200;  // Anzahl der Schritte pro Umdrehung des Schrittmotors 
final int Y_STEPS_PER_MM = 200;  
final int Z_STEPS_PER_MM = 200;  
final String serialPort = "/dev/ttyUSB0";
final float XMAX_MM = 450;   // Breite des Fräsebereichs
final float YMAX_MM = 300;   // Höhe des Fräsbereichs
final int DISPLAY_ORG_X = 190;   // Linke obere Ecke des Grafikfensters 
final int DISPLAY_ORG_Y = 0;    
final int DISPLAY_SCALE = 2;     // Pixel pro mm

//--------- Globale Variablen ---------------------
int windowSizeX = int(XMAX_MM)*2 + 200;
int windowSizeY = int(YMAX_MM)*2 + 60;
int lastZPos;  // -1 wenn im Material; 0 wenn auf der Oberfläche; 1 wenn angehoben
boolean vectorInProgress;  // Zeigt an, dass der Arduino noch beschäftigt ist
boolean sendVectors;       // Zeigt an, ob vektoren gesendet werden sollen
boolean zAction;           // Wir gebraucht, um auf die auf/ab-Bewegung zu warten
MillVector vector = null;
MillVectorList MillList = null;

ControlP5 controlP5;

Textfield Durchmesser;
Textfield Geschwindigkeit;
Textfield Tiefe;
Textfield Hub;
controlP5.Button Zoom1;
controlP5.Button Zoom2;
controlP5.Button FraeseEIN;
controlP5.Button FraeseAUS;

// The serial port:
Serial myPort;  

void setup() {
  int i;
  size(windowSizeX,windowSizeY);
  frameRate(30);
  
  controlP5 = new ControlP5(this);

  Durchmesser = controlP5.addTextfield("Durchmesser",75,20,40,20);
  Durchmesser.setText("2");
  Durchmesser.setColorCaptionLabel(0);
  Durchmesser.setColorBackground(#FFFFFF);
  Durchmesser.setColorValueLabel(0);
  Geschwindigkeit = controlP5.addTextfield("Geschwindigkeit",75,60,40,20);
  Geschwindigkeit.setText("255");
  Geschwindigkeit.setColorBackground(#FFFFFF);
  Geschwindigkeit.setColorCaptionLabel(0);
  Geschwindigkeit.setColorValueLabel(0);
  
  //Geschwindigkeit.setColorBackground(#FFFFFF);
  Tiefe = controlP5.addTextfield("Fraestiefe",75,100,40,20);
  Tiefe.setText("3");
  Tiefe.setColorCaptionLabel(0);
  Tiefe.setColorBackground(#FFFFFF);
  Tiefe.setColorValueLabel(0);
  Hub = controlP5.addTextfield("Hubhoehe",75,140,40,20);
  Hub.setText("4");
  Hub.setColorCaptionLabel(0);
  Hub.setColorBackground(#FFFFFF);
  Hub.setColorValueLabel(0);

  controlP5.addButton("Load",0,45,windowSizeY-200,100,19).setId(7);
  controlP5.addButton("Home",0,45,windowSizeY-160,100,19).setId(8);
  controlP5.addButton("Start",0,45,windowSizeY-120,100,19).setId(9);
  controlP5.addButton("Pause",255,45,windowSizeY-80,100,19).setId(10);
  controlP5.addButton("Continue",128,45,windowSizeY-40,100,19).setId(11);
  controlP5.addButton("Exit",128,windowSizeX-110,windowSizeY-40,100,19).setId(12);

  controlP5.addButton("Z+",128,75,windowSizeY/2-130,30,30).setId(25);
  controlP5.addButton("Z-",128,75,windowSizeY/2-90,30,30).setId(26);
  controlP5.addButton("Y+",128,75,windowSizeY/2-45,30,30).setId(22);
  controlP5.addButton("X-",128,40,windowSizeY/2-10,30,30).setId(21);
  controlP5.addButton("X+",128,110,windowSizeY/2-10,30,30).setId(24);
  controlP5.addButton("Y-",128,75,windowSizeY/2+25,30,30).setId(23);

  FraeseEIN = controlP5.addButton("EIN",128,55,windowSizeY/2+70,30,30).setId(27);
  FraeseEIN.setColorBackground(#00FF00);
  FraeseAUS = controlP5.addButton("AUS",128,95,windowSizeY/2+70,30,30).setId(28);
  FraeseAUS.setColorBackground(#FF0000);

  controlP5.addButton("Aktualisieren",128,200,windowSizeY-40,80,19).setId(30);
  Zoom1 = controlP5.addButton("Zoom x1",128,300,windowSizeY-40,80,19).setId(31);
  Zoom2 = controlP5.addButton("Zoom x2",128,400,windowSizeY-40,80,19).setId(32);
  
  println("Serial Interfaces found!");
  println(Serial.list());
  myPort = new Serial(this, serialPort, 9600);

  fill(255);
  stroke(0);
  strokeWeight(1);
  rect(DISPLAY_ORG_X, DISPLAY_ORG_Y, int(XMAX_MM)*DISPLAY_SCALE, int(YMAX_MM)*DISPLAY_SCALE);

  vectorInProgress = false;
  sendVectors = false;
  zAction = false;
}


// Diese Funktion wird automatisch 30x pro Sekunde aufgerufen. Daher sollte das Polling des Ports 
// funktionieren.
// Hier fordert der Arduino jeweils einen neuen Vector an.
void draw() {
   char inByte='0';
   
   if (myPort.available() > 0) {    
      inByte = myPort.readChar();
      println(inByte);             // nur für debug
      if (inByte == '?') vectorInProgress = false;   // Der Arduino meldet, dass er fertig ist
   }
   
   if (sendVectors && !vectorInProgress) {   // neue Vektoren anfordern, wenn der Arduino fertig ist  
        
     if (!zAction) vector = MillList.getNextVector();   // Nur neuen Vektor holen, wenn die letzte Aktion keine Z-Bewegung war
        
     if (vector != null)  {  
        if (!zAction) { // Es kommen keine zwei z-Bewegungen hintereinander
          if ((lastZPos == 0) && (vector.isDown())) {
            zDrive(float(Tiefe.getText())*-1);
            lastZPos = -1;
          } else 
          if ((lastZPos == 0) && (!vector.isDown())) {
            zDrive(float(Hub.getText()));
            lastZPos = 1;
          } else
          if ((lastZPos == 1) && (vector.isDown())) {
            zDrive(-1*float(Hub.getText()) - float(Tiefe.getText()));
            lastZPos = -1;
          } else 
          if ((lastZPos == -1) && (!vector.isDown())) {
            zDrive(float(Hub.getText()) + float(Tiefe.getText()));
            lastZPos = 1;
          }
        }
        
        // Mit diesem if-statement wird verhindert, dass direkt hinter einer Z-Aktion der nächste vektpr gesendet wird       
        if (!vectorInProgress) xyDrive(vector.getX(), vector.getY()); // Jetzt die x- und y-Achse fahren
      }
      else {
        sendVectors = false;   //   Aufhören, wenn keine Vektoren mehr da sind.
        myPort.write('f');  // Fräsmotor ausschalten 
      } 
   }
}


// Hier werden die GUI Events verarbeitet

public void controlEvent(ControlEvent theEvent) {
int i, speed;
String hexSpeed;
float diameter;

  println("got a control event from controller with id "+theEvent.controller().id());
  switch(theEvent.controller().id()) {
    case(7): // Load
      println("Load");
      Zoom1.setColorBackground(#FF0000);
      selectInput("PLT Datei Auswählen", "fileSelected");
    break;
    case(8): // Home
      println("Home");
       testGetVector();
    break;
    case(9): // Start
      println("Start");
      if (MillList!=null) {
        MillList.rewind();
        speed = int(Geschwindigkeit.getText());
        if (speed<0) speed = 0;
        if (speed>255) speed = 255;
        myPort.write('%');
        hexSpeed = hex(255-speed);
        myPort.write(hexSpeed.substring(hexSpeed.length()-2));
        //println(hexSpeed.substring(hexSpeed.length()-2));
        sendVectors = true;  // Ab jetzt werden Fräsdaten gesendet
        lastZPos = 0;  // Es wird angenommen, dass sich der Fräser auf der Materialoberfläche befindet
        myPort.write('F');  // Fräsmotor einschalten
      }
    break;
    case(10): // Pause
      println("Pause");
      sendVectors = false;
      //testGetVector();
    break;
    case(11): // Continue
      println("Continue");
      sendVectors = true;
    break;
    case(12): // Exit
      println("Exit");
      exit();
    break;
    case(21):
      println("X-");
      myPort.write('x');
    break;
    case(22):
      println("Y+");
      myPort.write('Y');
    break;
    case(23):
      println("Y-");
      myPort.write('y');
    break;
    case(24):
      println("X+");
      myPort.write('X');
    break;
    case(25):
      println("Z+");
      myPort.write('Z');
      //myPort.write("+00FF");  // Nur zum Testen der festen Fahrstrecke für die Z-Achse
    break;
    case(26):
      println("Z-");
      myPort.write('z');
    break;
    case(27):
      println("Fräse EIN");
      myPort.write('F');
    break;
    case(28):
      println("Fräse AUS");
      myPort.write('f');
    break;
    case(30):
      println("Aktualisieren");
      Zoom1.setColorBackground(#FF0000);
      Zoom2.setColorBackground(#02344D);
      diameter = float(Durchmesser.getText());
      fill(255);
      stroke(0);
      strokeWeight(1);
      rect(DISPLAY_ORG_X, DISPLAY_ORG_Y, int(XMAX_MM)*DISPLAY_SCALE, int(YMAX_MM)*DISPLAY_SCALE);
      if (MillList!=null) MillList.plot(DISPLAY_ORG_X, DISPLAY_ORG_Y + int(YMAX_MM)*DISPLAY_SCALE, DISPLAY_SCALE,diameter);
    break;    
    case(31):
      println("Zoom x1");
      Zoom1.setColorBackground(#FF0000);
      Zoom2.setColorBackground(#02344D);
      diameter = float(Durchmesser.getText());
      fill(255);
      stroke(0);
      strokeWeight(1);
      rect(DISPLAY_ORG_X, DISPLAY_ORG_Y, int(XMAX_MM)*DISPLAY_SCALE, int(YMAX_MM)*DISPLAY_SCALE);
      if (MillList!=null) MillList.plot(DISPLAY_ORG_X, DISPLAY_ORG_Y + int(YMAX_MM)*DISPLAY_SCALE, DISPLAY_SCALE,diameter);
    break;  
    case(32):
      println("Zoom x2");
      Zoom2.setColorBackground(#FF0000);
      Zoom1.setColorBackground(#02344D);
      diameter = float(Durchmesser.getText());
      fill(255);
      stroke(0);
      strokeWeight(1);
      rect(DISPLAY_ORG_X, DISPLAY_ORG_Y, int(XMAX_MM)*DISPLAY_SCALE, int(YMAX_MM)*DISPLAY_SCALE);
      if (MillList!=null) MillList.plot(DISPLAY_ORG_X, DISPLAY_ORG_Y + int(YMAX_MM)*DISPLAY_SCALE, DISPLAY_SCALE*2,diameter);
    break;  
  }
}

void fileSelected(File selection) {
  float diameter;
  
  if (selection!=null) {
    MillList = new MillVectorList();
    MillList.loadPLT(selection.getAbsolutePath());
    diameter = float(Durchmesser.getText());
    MillList.plot(DISPLAY_ORG_X, DISPLAY_ORG_Y + int(YMAX_MM)*DISPLAY_SCALE, DISPLAY_SCALE,diameter);
  }
}

// Fahre z mm in z-Richtung
void zDrive(float z) {
  String hexStr;
  int zSteps;
  
  zSteps = int(abs((z * Z_STEPS_PER_MM)));
  hexStr = hex(zSteps);
  
  if (z > 0) myPort.write('+'); else myPort.write('-');
  myPort.write(hexStr.substring(hexStr.length()-4));
  println("zDrive: "+hexStr.substring(hexStr.length()-4));
  vectorInProgress = true;  // ab jetzt hat erst mal der Arduino zu tun, bis er sich wieder zutückmeldet
  zAction = true;
}

// Fahre die x-und y-Achse gleichzeitig um x mm und y mm 
void xyDrive(float x, float y) {
  float stepsX, stepsY, linDist;
  float aspectX, aspectY;
  int stp, aspX, aspY;
  char aspXsign, aspYsign;
  char xySelect, stpSign;
  String outStr, aspXhex, aspYhex, stpHex;
  
  println("x= ",x,"mm   y= ",y,"mm"); 
  
  stepsX = x*X_STEPS_PER_MM;
  stepsY = y*Y_STEPS_PER_MM;
  linDist = int(sqrt(stepsX*stepsX + stepsY*stepsY));     // Vektorlänge in steps (Pytagoras)
  
  if (stepsX!=0) aspectX=linDist*30/stepsX; else aspectX=linDist*100;   // Berechnung der cycles pro Schritt 
  if (stepsY!=0) aspectY=linDist*30/stepsY; else aspectY=linDist*100;
  if (abs(aspectX)>32000) aspectX=32000;   // Sicherstellen, dass es keinen Überlauf gibt
  if (abs(aspectY)>32000) aspectY=32000; 
  
  aspX= int(aspectX);
  aspY= int(aspectY);
  
  //Abhängig davon, ob mehr X- oder Y-Schritte gebraucht werden, wird die Referenz für die Total-Steps ausgewählt
  if (abs(stepsX)>abs(stepsY)) {
    stp= int(stepsX);
    xySelect = 'X';
  }
  else {
    stp = int(stepsY);
    xySelect = 'Y';
  } 
  
  if (stp>=0) stpSign='+'; else stpSign='-';     // Vorzeichen setzen
  if (aspX>=0) aspXsign='+'; else aspXsign='-';
  if (aspY>=0) aspYsign='+'; else aspYsign='-';
  
  // Nur für Debug
  println(" # "+stp+" - "+aspX+" * "+aspY+" * "+xySelect);
  
  stpHex = hex(abs(stp));
  aspXhex = hex(abs(aspX));
  aspYhex = hex(abs(aspY));
  
  //xySelect wird am Anfang ausgegeben, damit der Arduino weiß, auf welche Achse sich die Steps beziehen
  outStr= stpSign + stpHex.substring(4) +  aspXsign + aspXhex.substring(4) + aspYsign + aspYhex.substring(4);
  outStr = xySelect + outStr; 
  
  myPort.write('!');
  myPort.write(outStr);
  //Debug
  println("--> "+outStr);

  vectorInProgress = true;  // ab jetzt hat erst mal der Arduino zu tun, bis er sich wieder zutückmeldet
  zAction = false;  //Das war keine Z-Bewegung
}



//############################ Funktionen zum testen der Software ####################################

// Hier werden die Vektoren testweise mal alle ausgelesen
void testGetVector() {
  MillVector v;
  do {
    println("-----");
    v = MillList.getNextVector();
    if (v!=null) {
      println("X = ",v.getX());
      println("Y = ",v.getY());
      println("isDown = ",v.isDown());
    }
  } while (v!=null);
  MillList.rewind();
}
