/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Button;
import controlP5.CColor;
import controlP5.CDrawable;
import controlP5.CP;
import controlP5.Canvas;
import controlP5.ControlEvent;
import controlP5.ControlFont;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControlP5Constants;
import controlP5.ControlWindow;
import controlP5.Controller;
import controlP5.ControllerInterface;
import controlP5.ControllerList;
import controlP5.ControllerProperty;
import controlP5.Label;
import controlP5.Tab;
import java.util.ArrayList;
import java.util.List;
import processing.core.PApplet;
import processing.core.PVector;
import processing.event.KeyEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControllerGroup<T>
implements ControllerInterface<T>,
ControlP5Constants,
ControlListener {
    protected PVector position;
    protected PVector positionBuffer;
    protected PVector absolutePosition;
    protected ControllerList controllers;
    protected List<ControlListener> _myControlListener;
    protected ControlP5 cp5;
    protected ControllerGroup<?> _myParent;
    protected String _myName;
    protected int _myId = -1;
    protected CColor color = new CColor();
    protected boolean isMousePressed = false;
    protected boolean isInside = false;
    protected boolean isInsideGroup = false;
    protected boolean isVisible = true;
    protected boolean isOpen = true;
    protected boolean isBarVisible = true;
    protected boolean isArrowVisible = true;
    protected Button _myCloseButton;
    protected boolean isMoveable = true;
    protected Label _myLabel;
    protected Label _myValueLabel;
    protected int _myWidth = 99;
    protected int _myHeight = 9;
    protected boolean isUpdate;
    protected List<Canvas> _myCanvas;
    protected float _myValue;
    protected String _myStringValue;
    protected float[] _myArrayValue;
    protected boolean isCollapse = true;
    protected int _myPickingColor = 0x6600FFFF;
    protected PVector autoPosition = new PVector(10.0f, 30.0f, 0.0f);
    protected float tempAutoPositionHeight = 0.0f;
    protected float autoPositionOffsetX = 10.0f;
    private String _myAddress = "";
    private boolean mouseover;
    protected final T me;

    public ControllerGroup(ControlP5 controlP5, String string) {
        this(controlP5, controlP5.getDefaultTab(), string, 0.0f, 0.0f);
        controlP5.register(controlP5.papplet, string, this);
    }

    public ControllerGroup(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, float f, float f2) {
        this.position = new PVector(f, f2, 0.0f);
        this.cp5 = controlP5;
        this.me = this;
        this.color.set(controllerGroup == null ? ControlP5.color : controllerGroup.color);
        this._myName = string;
        this.controllers = new ControllerList();
        this._myCanvas = new ArrayList<Canvas>();
        this._myControlListener = new ArrayList<ControlListener>();
        this._myLabel = new Label(this.cp5, this._myName);
        this._myLabel.setText(this._myName);
        this._myLabel.setColor(this.color.getCaptionLabel());
        this._myLabel.align(37, 101);
        this.setParent(controllerGroup == null ? this : controllerGroup);
    }

    protected ControllerGroup(int n, int n2) {
        this.position = new PVector((float)n, (float)n2, 0.0f);
        this.me = this;
        this.controllers = new ControllerList();
        this._myCanvas = new ArrayList<Canvas>();
    }

    @Override
    @ControlP5.Invisible
    public void init() {
    }

    @Override
    @ControlP5.Invisible
    public ControllerInterface<?> getParent() {
        return this._myParent;
    }

    void setParent(ControllerGroup<?> controllerGroup) {
        if (this._myParent != null && this._myParent != this) {
            this._myParent.remove(this);
        }
        this._myParent = controllerGroup;
        if (this._myParent != this) {
            this._myParent.add(this);
        }
        this.absolutePosition = new PVector(this.position.x, this.position.y);
        this.absolutePosition.add(this._myParent.absolutePosition);
        this.positionBuffer = new PVector(this.position.x, this.position.y);
        if (this.cp5.getWindow() != null) {
            this.setMouseOver(false);
        }
    }

    public final T setGroup(ControllerGroup<?> controllerGroup) {
        this.setParent(controllerGroup);
        return this.me;
    }

    public final T setGroup(String string) {
        this.setParent(this.cp5.getGroup(string));
        return this.me;
    }

    @Override
    public final T moveTo(ControllerGroup<?> controllerGroup, Tab tab, ControlWindow controlWindow) {
        if (controllerGroup != null) {
            this.setGroup(controllerGroup);
            return this.me;
        }
        if (controlWindow == null) {
            controlWindow = this.cp5.controlWindow;
        }
        this.setTab(controlWindow, tab.getName());
        return this.me;
    }

    @Override
    public final T moveTo(ControllerGroup<?> controllerGroup) {
        this.moveTo(controllerGroup, null, null);
        return this.me;
    }

    public final T moveTo(Tab tab) {
        this.moveTo(null, tab, tab.getWindow());
        return this.me;
    }

    public T moveTo(PApplet pApplet) {
        this.moveTo(this.cp5.controlWindow);
        return this.me;
    }

    public T moveTo(ControlWindow controlWindow) {
        this.moveTo(null, controlWindow.getTab("default"), controlWindow);
        return this.me;
    }

    public final T moveTo(String string) {
        this.moveTo(null, this.cp5.controlWindow.getTab(string), this.cp5.controlWindow);
        return this.me;
    }

    public final T moveTo(String string, ControlWindow controlWindow) {
        this.moveTo(null, controlWindow.getTab(string), controlWindow);
        return this.me;
    }

    public final T moveTo(ControlWindow controlWindow, String string) {
        this.moveTo(null, controlWindow.getTab(string), controlWindow);
        return this.me;
    }

    public final T moveTo(Tab tab, ControlWindow controlWindow) {
        this.moveTo(null, tab, controlWindow);
        return this.me;
    }

    public final T setTab(String string) {
        this.setParent(this.cp5.getTab(string));
        return this.me;
    }

    public final T setTab(ControlWindow controlWindow, String string) {
        this.setParent(this.cp5.getTab(controlWindow, string));
        return this.me;
    }

    public final T setTab(Tab tab) {
        this.setParent(tab);
        return this.me;
    }

    @Override
    public Tab getTab() {
        if (this instanceof Tab) {
            return (Tab)this;
        }
        if (this._myParent instanceof Tab) {
            return (Tab)this._myParent;
        }
        return this._myParent.getTab();
    }

    protected void updateFont(ControlFont controlFont) {
        this._myLabel.updateFont(controlFont);
        if (this._myValueLabel != null) {
            this._myValueLabel.updateFont(controlFont);
        }
        for (int i = 0; i < this.controllers.size(); ++i) {
            if (this.controllers.get(i) instanceof Controller) {
                ((Controller)this.controllers.get(i)).updateFont(controlFont);
                continue;
            }
            ((ControllerGroup)this.controllers.get(i)).updateFont(controlFont);
        }
    }

    @Override
    @ControlP5.Invisible
    public PVector getAbsolutePosition() {
        return new PVector(this.absolutePosition.x, this.absolutePosition.y);
    }

    @Override
    @ControlP5.Invisible
    public T setAbsolutePosition(PVector pVector) {
        this.absolutePosition.set(pVector.x, pVector.y, pVector.z);
        return this.me;
    }

    @Override
    public PVector getPosition() {
        return new PVector(this.position.x, this.position.y);
    }

    @Override
    public T setPosition(float f, float f2) {
        this.position.set((float)((int)f), (float)((int)f2), 0.0f);
        this.positionBuffer.set(this.position);
        this.updateAbsolutePosition();
        return this.me;
    }

    @Override
    public T setPosition(PVector pVector) {
        this.setPosition(pVector.x, pVector.y);
        return this.me;
    }

    @Override
    public T updateAbsolutePosition() {
        this.absolutePosition.set(this.position);
        this.absolutePosition.add(this._myParent.getAbsolutePosition());
        for (int i = 0; i < this.controllers.size(); ++i) {
            this.controllers.get(i).updateAbsolutePosition();
        }
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public void continuousUpdateEvents() {
        if (this.controllers.size() <= 0) {
            return;
        }
        for (int i = this.controllers.size() - 1; i >= 0; --i) {
            this.controllers.get(i).continuousUpdateEvents();
        }
    }

    @Override
    public T update() {
        if (this.controllers.size() <= 0) {
            return this.me;
        }
        for (int i = this.controllers.size() - 1; i >= 0; --i) {
            if (!this.controllers.get(i).isUpdate()) continue;
            this.controllers.get(i).update();
        }
        return this.me;
    }

    @Override
    public T setUpdate(boolean bl) {
        this.isUpdate = bl;
        for (int i = 0; i < this.controllers.size(); ++i) {
            this.controllers.get(i).setUpdate(bl);
        }
        return this.me;
    }

    @Override
    public boolean isUpdate() {
        return this.isUpdate;
    }

    @Override
    @ControlP5.Invisible
    public T updateEvents() {
        if (this.isOpen) {
            for (int i = this.controllers.size() - 1; i >= 0; --i) {
                this.controllers.get(i).updateEvents();
            }
        }
        if (this.isVisible && this.isMousePressed == this.cp5.getWindow().mouselock) {
            if (this.isMousePressed && this.cp5.isAltDown() && this.isMoveable) {
                if (!this.cp5.isMoveable) {
                    this.positionBuffer.x += (float)(this.cp5.getWindow().mouseX - this.cp5.getWindow().pmouseX);
                    this.positionBuffer.y += (float)(this.cp5.getWindow().mouseY - this.cp5.getWindow().pmouseY);
                    if (this.cp5.isShiftDown()) {
                        this.position.x = (int)this.positionBuffer.x / 10 * 10;
                        this.position.y = (int)this.positionBuffer.y / 10 * 10;
                    } else {
                        this.position.set(this.positionBuffer);
                    }
                    this.updateAbsolutePosition();
                }
            } else {
                if (this.isInside) {
                    this.setMouseOver(true);
                }
                if (this.inside()) {
                    if (!this.isInside) {
                        this.isInside = true;
                        this.onEnter();
                        this.setMouseOver(true);
                    }
                } else if (this.isInside && !this.isMousePressed) {
                    this.onLeave();
                    this.isInside = false;
                    this.setMouseOver(false);
                }
            }
        }
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public T updateInternalEvents(PApplet pApplet) {
        return this.me;
    }

    @Override
    public boolean isMouseOver() {
        this.mouseover = this.isInside || this.isInsideGroup || !this.isBarVisible;
        return this.mouseover;
    }

    @Override
    public T setMouseOver(boolean bl) {
        boolean bl2 = this.mouseover = !this.isBarVisible ? false : bl;
        if (!this.mouseover) {
            this.isInside = false;
            this.isInsideGroup = false;
            this.cp5.getWindow().removeMouseOverFor(this);
            for (int i = this.controllers.size() - 1; i >= 0; --i) {
                this.controllers.get(i).setMouseOver(false);
            }
        } else {
            this.cp5.getWindow().setMouseOverController(this);
        }
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public final void draw(PApplet pApplet) {
        if (this.isVisible) {
            pApplet.pushMatrix();
            pApplet.translate(this.position.x, this.position.y);
            this.preDraw(pApplet);
            this.drawControllers(pApplet);
            this.postDraw(pApplet);
            if (this._myValueLabel != null) {
                this._myValueLabel.draw(pApplet, 2, 2, this);
            }
            pApplet.popMatrix();
        }
    }

    protected void drawControllers(PApplet pApplet) {
        if (this.isOpen) {
            for (Canvas object : this._myCanvas) {
                if (object.mode() != 0) continue;
                object.draw(pApplet);
            }
            for (ControllerInterface controllerInterface : this.controllers.get()) {
                if (!controllerInterface.isVisible()) continue;
                controllerInterface.updateInternalEvents(pApplet);
                controllerInterface.draw(pApplet);
            }
            for (CDrawable cDrawable : this.controllers.getDrawables()) {
                cDrawable.draw(pApplet);
            }
            for (Canvas canvas : this._myCanvas) {
                if (canvas.mode() != 1) continue;
                canvas.draw(pApplet);
            }
        }
    }

    protected void preDraw(PApplet pApplet) {
    }

    protected void postDraw(PApplet pApplet) {
    }

    public Canvas addCanvas(Canvas canvas) {
        this._myCanvas.add(canvas);
        canvas.setup(this.cp5.papplet);
        return canvas;
    }

    public T removeCanvas(Canvas canvas) {
        this._myCanvas.remove(canvas);
        return this.me;
    }

    @Override
    public T add(ControllerInterface<?> controllerInterface) {
        this.controllers.add(controllerInterface);
        return this.me;
    }

    @Override
    public T bringToFront() {
        return this.bringToFront(this);
    }

    @Override
    public T bringToFront(ControllerInterface<?> controllerInterface) {
        if (this._myParent instanceof Tab) {
            this.moveTo((Tab)this._myParent);
        } else {
            this._myParent.bringToFront(controllerInterface);
        }
        if (controllerInterface != this && this.controllers.get().contains(controllerInterface)) {
            this.controllers.remove(controllerInterface);
            this.controllers.add(controllerInterface);
        }
        return this.me;
    }

    @Override
    public T remove(ControllerInterface<?> controllerInterface) {
        if (controllerInterface != null) {
            controllerInterface.setMouseOver(false);
        }
        this.controllers.remove(controllerInterface);
        return this.me;
    }

    @ControlP5.Invisible
    public T addDrawable(CDrawable cDrawable) {
        this.controllers.addDrawable(cDrawable);
        return this.me;
    }

    public T remove(CDrawable cDrawable) {
        this.controllers.removeDrawable(cDrawable);
        return this.me;
    }

    @Override
    public void remove() {
        this.cp5.getWindow().removeMouseOverFor(this);
        if (this._myParent != null) {
            this._myParent.remove(this);
        }
        if (this.cp5 != null) {
            this.cp5.remove(this);
        }
        for (int i = this.controllers.size() - 1; i >= 0; --i) {
            this.controllers.get(i).remove();
        }
        this.controllers.clear();
        this.controllers.clearDrawable();
        this.controllers = new ControllerList();
        if (this instanceof Tab) {
            this.cp5.getWindow().removeTab((Tab)this);
        }
    }

    @Override
    public String getName() {
        return this._myName;
    }

    @Override
    public String getAddress() {
        return this._myAddress;
    }

    @Override
    public T setAddress(String string) {
        if (this._myAddress.length() == 0) {
            this._myAddress = string;
        }
        return this.me;
    }

    @Override
    public ControlWindow getWindow() {
        return this.cp5.getWindow();
    }

    @Override
    @ControlP5.Invisible
    public void keyEvent(KeyEvent keyEvent) {
        for (int i = 0; i < this.controllers.size(); ++i) {
            this.controllers.get(i).keyEvent(keyEvent);
        }
    }

    @Override
    public boolean setMousePressed(boolean bl) {
        if (!this.isVisible) {
            return false;
        }
        for (int i = this.controllers.size() - 1; i >= 0; --i) {
            if (!this.controllers.get(i).setMousePressed(bl)) continue;
            return true;
        }
        if (bl) {
            if (this.isInside) {
                this.isMousePressed = true;
                this.mousePressed();
                return true;
            }
        } else if (this.isMousePressed) {
            this.isMousePressed = false;
            this.mouseReleased();
        }
        return false;
    }

    protected void mousePressed() {
    }

    protected void mouseReleased() {
    }

    protected void onEnter() {
    }

    protected void onLeave() {
    }

    protected void onScroll(int n) {
    }

    @Override
    public T setId(int n) {
        this._myId = n;
        return this.me;
    }

    @Override
    public int getId() {
        return this._myId;
    }

    @Override
    public T setColor(CColor cColor) {
        for (ControllerInterface<?> controllerInterface : this.controllers.get()) {
            controllerInterface.setColor(cColor);
        }
        return this.me;
    }

    @Override
    public T setColorActive(int n) {
        this.color.setActive(n);
        for (ControllerInterface<?> controllerInterface : this.controllers.get()) {
            controllerInterface.setColorActive(n);
        }
        return this.me;
    }

    @Override
    public T setColorForeground(int n) {
        this.color.setForeground(n);
        for (ControllerInterface<?> controllerInterface : this.controllers.get()) {
            controllerInterface.setColorForeground(n);
        }
        return this.me;
    }

    @Override
    public T setColorBackground(int n) {
        this.color.setBackground(n);
        for (ControllerInterface<?> controllerInterface : this.controllers.get()) {
            controllerInterface.setColorBackground(n);
        }
        return this.me;
    }

    @Override
    public T setColorLabel(int n) {
        this.color.setCaptionLabel(n);
        if (this._myLabel != null) {
            this._myLabel.setColor(this.color.getCaptionLabel());
        }
        for (ControllerInterface<?> controllerInterface : this.controllers.get()) {
            controllerInterface.setColorLabel(n);
        }
        return this.me;
    }

    @Override
    public T setColorValue(int n) {
        this.color.setValueLabel(n);
        if (this._myValueLabel != null) {
            this._myValueLabel.setColor(this.color.getValueLabel());
        }
        for (ControllerInterface<?> controllerInterface : this.controllers.get()) {
            controllerInterface.setColorValue(n);
        }
        return this.me;
    }

    @Override
    public T setLabel(String string) {
        this._myLabel.set(string);
        return this.me;
    }

    @Override
    public boolean isVisible() {
        if (this._myParent != null && this._myParent != this && !this.getParent().isVisible()) {
            return false;
        }
        return this.isVisible;
    }

    public T setVisible(boolean bl) {
        this.isVisible = bl;
        return this.me;
    }

    @Override
    public T hide() {
        this.isVisible = false;
        return this.me;
    }

    @Override
    public T show() {
        this.isVisible = true;
        return this.me;
    }

    public T setMoveable(boolean bl) {
        this.isMoveable = bl;
        return this.me;
    }

    public boolean isMoveable() {
        return this.isMoveable;
    }

    public T setOpen(boolean bl) {
        this.isOpen = bl;
        return this.me;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public T open() {
        this.setOpen(true);
        return this.me;
    }

    public T close() {
        this.setOpen(false);
        return this.me;
    }

    @ControlP5.Invisible
    public T removeCloseButton() {
        if (this._myCloseButton == null) {
            this._myCloseButton.remove();
        }
        this._myCloseButton = null;
        return this.me;
    }

    public T setTitle(String string) {
        this.getCaptionLabel().set(string);
        return this.me;
    }

    public T hideBar() {
        this.isBarVisible = false;
        return this.me;
    }

    public T showBar() {
        this.isBarVisible = true;
        return this.me;
    }

    public boolean isBarVisible() {
        return this.isBarVisible;
    }

    public T hideArrow() {
        this.isArrowVisible = false;
        return this.me;
    }

    public T showArrow() {
        this.isArrowVisible = true;
        return this.me;
    }

    @ControlP5.Invisible
    public T addCloseButton() {
        if (this._myCloseButton == null) {
            this._myCloseButton = new Button(this.cp5, this, this.getName() + "close", 1.0f, this._myWidth + 1, -10, 12, 9);
            this._myCloseButton.setCaptionLabel("X");
            this._myCloseButton.addListener(this);
        }
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public int getPickingColor() {
        return this._myPickingColor;
    }

    @Override
    public CColor getColor() {
        return this.color;
    }

    @Override
    public T setValue(float f) {
        this._myValue = f;
        return this.me;
    }

    @Override
    public float getValue() {
        return this._myValue;
    }

    @Override
    public String getStringValue() {
        return this._myStringValue;
    }

    @Override
    public T setStringValue(String string) {
        this._myStringValue = string;
        return this.me;
    }

    @Override
    public float[] getArrayValue() {
        return this._myArrayValue;
    }

    @Override
    public float getArrayValue(int n) {
        if (n >= 0 && n < this._myArrayValue.length) {
            return this._myArrayValue[n];
        }
        return Float.NaN;
    }

    @Override
    public T setArrayValue(int n, float f) {
        if (n >= 0 && n < this._myArrayValue.length) {
            this._myArrayValue[n] = f;
        }
        return this.me;
    }

    @Override
    public T setArrayValue(float[] fArray) {
        this._myArrayValue = fArray;
        return this.me;
    }

    public Controller<?> getController(String string) {
        return this.cp5.getController(string);
    }

    @Override
    public T setCaptionLabel(String string) {
        this.getCaptionLabel().set(string);
        return this.me;
    }

    public Label getCaptionLabel() {
        return this._myLabel;
    }

    public Label getValueLabel() {
        return this._myValueLabel;
    }

    public T enableCollapse() {
        this.isCollapse = true;
        return this.me;
    }

    public T disableCollapse() {
        this.isCollapse = false;
        return this.me;
    }

    public boolean isCollapse() {
        return this.isCollapse;
    }

    @Override
    public int getWidth() {
        return this._myWidth;
    }

    @Override
    public int getHeight() {
        return this._myHeight;
    }

    public T setWidth(int n) {
        this._myWidth = n;
        return this.me;
    }

    public T setHeight(int n) {
        this._myHeight = n;
        return this.me;
    }

    public T setSize(int n, int n2) {
        this.setWidth(n);
        return this.me;
    }

    protected boolean inside() {
        return (float)this.cp5.getWindow().mouseX > this.position.x + this._myParent.absolutePosition.x && (float)this.cp5.getWindow().mouseX < this.position.x + this._myParent.absolutePosition.x + (float)this._myWidth && (float)this.cp5.getWindow().mouseY > this.position.y + this._myParent.absolutePosition.y - (float)this._myHeight && (float)this.cp5.getWindow().mouseY < this.position.y + this._myParent.absolutePosition.y;
    }

    @Override
    public ControllerProperty getProperty(String string) {
        return this.cp5.getProperties().getProperty(this, string);
    }

    @Override
    public ControllerProperty getProperty(String string, String string2) {
        return this.cp5.getProperties().getProperty(this, string, string2);
    }

    @Override
    public T registerProperty(String string) {
        this.cp5.getProperties().register(this, string);
        return this.me;
    }

    @Override
    public T registerProperty(String string, String string2) {
        this.cp5.getProperties().register(this, string, string2);
        return this.me;
    }

    @Override
    public T removeProperty(String string) {
        this.cp5.getProperties().remove((ControllerInterface<?>)this, string);
        return this.me;
    }

    @Override
    public T removeProperty(String string, String string2) {
        this.cp5.getProperties().remove((ControllerInterface<?>)this, string, string2);
        return this.me;
    }

    @Override
    public void controlEvent(ControlEvent controlEvent) {
    }

    @Override
    public T addListener(ControlListener controlListener) {
        this._myControlListener.add(controlListener);
        return this.me;
    }

    public T removeListener(ControlListener controlListener) {
        this._myControlListener.remove(controlListener);
        return this.me;
    }

    public int listenerSize() {
        return this._myControlListener.size();
    }

    public String toString() {
        return this.getName() + " [" + this.getClass().getSimpleName() + "]";
    }

    public String getInfo() {
        return "type:\tControllerGroup\nname:\t" + this._myName + "\n" + "label:\t" + this._myLabel.getText() + "\n" + "id:\t" + this._myId + "\n" + "value:\t" + this._myValue + "\n" + "arrayvalue:\t" + CP.arrayToString(this._myArrayValue) + "\n" + "position:\t" + this.position + "\n" + "absolute:\t" + this.absolutePosition + "\n" + "width:\t" + this.getWidth() + "\n" + "height:\t" + this.getHeight() + "\n" + "color:\t" + this.getColor() + "\n" + "visible:\t" + this.isVisible + "\n" + "moveable:\t" + this.isMoveable + "\n";
    }

    @Deprecated
    public PVector absolutePosition() {
        return this.getAbsolutePosition();
    }

    @Deprecated
    public PVector position() {
        return this.getPosition();
    }

    @Deprecated
    public CColor color() {
        return this.color;
    }

    @Deprecated
    public float value() {
        return this._myValue;
    }

    @Override
    @Deprecated
    public String stringValue() {
        return this.getStringValue();
    }

    @Deprecated
    public float[] arrayValue() {
        return this.getArrayValue();
    }

    @Override
    @Deprecated
    public String name() {
        return this._myName;
    }

    @Override
    @Deprecated
    public int id() {
        return this._myId;
    }

    @Deprecated
    public Controller<?> controller(String string) {
        return this.cp5.getController(string);
    }

    @Override
    @ControlP5.Invisible
    @Deprecated
    public ControllerInterface<?> parent() {
        return this._myParent;
    }

    @Deprecated
    public Label captionLabel() {
        return this._myLabel;
    }

    @Deprecated
    public Label valueLabel() {
        return this._myValueLabel;
    }
}

