/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CP;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import processing.core.PFont;
import processing.core.PImage;

public class BitFont
extends PFont {
    public static final String standard58base64 = "AakACQBgACAEAgQGBggGAgMDBAYDBAIGBQMFBQUFBQUFBQICBAUEBQgFBQUFBQUFBQIFBQQGBQUFBQUFBAUGCAUGBQMFAwYGAwQEBAQEBAQEAgQEAgYEBAQEAwQEBAQGBAQEBAIEBQKgUgghIaUAAIiRMeiZZwwAAANgjjnvmRRKESVzzDGXoqQUvYURQCCAQCCSCAAAAAgAAABEqECleCVFkRAAiLSUWEgoJQAAiSOllEJIKVRiSymllCRFSSlCEVIAQQBBQAARAAAAEAAAACQpgeALJASiIwAQSQipE1BKRS+QSEohhRBSqES1UkopSIqSkkIiFAGwEZOwSaplZGx2VVXVSQIAgeIgSETy4RCSCEnoEONAgJCkd0I6p73QiKilk46RpCQZQoQIAFBVVVOVVFVVVUKqqiqKCACCDyKpiIoAICQJ9FAiCUE8ElUphRRCSqESUUohJSRJSUpECBEAoCrqoiqZqqqqiFRVUiIJAADKI5UQASEgSAoJpSRSCgECUlJKKYSUSiWilEJKSRKRlIgQJABAVVVEVVJVVVUhqaqqQhIACBQixEIBQFBg9AwyRhhDBEIIpGPOCyZl0kXJBJOMGMImEW9owAcbMQmrpKpKxjJiopQdFQAAAAAAAABAAAAAAAAAAIAAAOAAAAAAAAAAAAAACAAAAAAAAAAAAAAAAAQIAAAEAQAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAgAAAgCAAAAAgAA";
    public static final String standard56base64 = "AeYACQBgACAEAgQGBggHAgMDBgYDBQIFBgMGBgYGBgYGBgIDBAYEBggGBgYGBgYGBgIGBgUIBgYGBgYGBgYGCAYGBgMFAwYHAwUFBQUFAwUFAgMFAggFBQUFBAQEBQUIBQUFBAMEBQKgUgghRwoBAIAcOQ7yOZ/jAADAAXAe5/k+JwqKQlDkPM7jfFGUFEXfwghAQAAICIQUAgAAAAABAAAAQAkVqBSvJFJUEQCQaFHEBBEURQAAiDiiKIqCIIqCkjAWRVEURUQUJUURFCEFIBAAAgEBhAAAAABAAAAAAEikBIIvkFAQOQQAJBIEKU8ARVGiLyCRKAqiIAiioCJUTVEURQERRUmKgkQoAsAd40zcSambY447u5SSUnoSAYBAcRBMRNWHh4iEMAn0II4HBBAk6XuC6HmyL2gISVX0RI9DREoSQRAhAgBIKaW0lFIpKaWUIiSlpJRQhAAg+CCSFBFBACAiEdAHRUgEgfiIqIqiIAqCKAoqQlAWBVEBEZGSpBBCiAAAUgrpJaU0SkoppRBJKckkIxEAAJRHKkIEEACESEKERBERRUEAAVKiKIqCIIqKkhAURUGUREREJEVEECQAgJRSCkkplZJSSilIUkpKKUgEAAKFCHGhAIBAwdHnII5DOA4iIAiB6HGeL3CinOgFRU7gRA7hEDYR8QUJ+MEd40xcSqmkZI6LEWdsknsSAQAAAAAAAAAgAAAAAAAAAACAAACAAwAAAAAAAAAAAAAAQAAAAAAAAAADAwAAAAAABBAAAICAAAAAAIAAJQAAAAAAAAAABAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwAACAAAgIAAAAAAYAAA=";
    public static final String grixelbase64 = "AnoADABgACAFAgQICAoIAgQEBgYDBQIKCQMICAgICAcICAIDBQYFBwkICAgIBwcICAYHCAcJCAgICAgICAgICggICAQKBAQHBAcHBwcHBQcHAgUHBAoHBwcHBgcGBwcKBwcHBQIFCAJAJeIjkENBAAAAQHzk4wPz5/Pz8QEAAB4ePj8+Pz6fX9AHCgoECvL58fnx+QsKiigo6C8CIAEIIAAAARwgEAoEAAAAAAAABAAAAAAAICIAAZVIUiERBQEAAIAIWlAQSkAQKCgIICCEhAQFBQUFAgFBBCgoMGwoKCgoKAghKCiioCCgEIAKQIAAAAQIgAAgEAAAAAAAABAAAAAAAICIsAUEfwlCRBCkEAAAIUhAQCQBAaCgIEAAAcoUFBQQFAgEBBGgoECpoqCgoKAAhKCgiEREQIIAAgAAAgAQIAACgEAAAAAAAABAAAAAAAAAIrIBEIgkgBBBEEEAAIIgAQGJ/ARAgoKS+AioVFBQQFAgEBBEgEICmZKCgoKCAhCCgiKioIAIBAgA4Pl4fJ7n+YRC8c7H8/F5ni8UiigU+okIAEAg4gOBA0HfhwcEguTDEwL0g/DxAwFAoFJ/PwFBv1/eHwH6CASKCgoKCvJBCAqKCAEBISAgAAAoFAqFQigUikREoVAoFISEUCgiSQgSQgAAgQgSAlEEEQQACAhSANAfUBAhCAiIj2BKBQUFBAUCQUEEKCQQKCzoJ+gHCCEoKCIKBIIAgQAAvlAg9AuhUOgREYVCoVBgEEKhiBghhIgAAAB/SITEEKQQABAgSAFAIEBBhCAgQABByBMUFBAUCAQFEaGgQKCgoICgECCEIJGIRBAEAggCAIRCgVAghEKhSEQUCoVCAUYIhSJihAgiAgAAiCQJFUMQAAgggCAFBIEEBRGCghACAkBAUFBQUCAQFESEggKBgoICkoKCEIIoIgpCCAhACAAQCoVCoRAKhUIRUSgUCgUhISSJSBISiAgAQCDiE4gTQQAgUAB89OcD4uND8PFJAAAEfkE/Pj++gF/Q5wn6BQryCfAJ8kHwQXAnCOEvACIAgM/j8XiCLxQKWUQhz8cXeDgPw52Q7yciAAAAAAIAANgAQAAAAAAAAAAAAAAAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAAAAAAAgAPg4AcAAAAAACAACAAAAAABEAAAAAAAACAAawAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB4ABgAAAAABEAAAAAAAAB4AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA=";
    protected int characters;
    protected int[] charWidth = new int[255];
    protected int charHeight;
    protected int[][] chars;
    protected int lineHeight = 10;
    protected int kerning = 0;
    protected int wh;
    protected PImage texture;

    public BitFont(byte[] byArray) {
        this.texture = this.decodeBitFont(byArray);
        this.make();
        this.size = this.lineHeight;
        this.glyphs = new PFont.Glyph[256];
        this.ascii = new int[128];
        Arrays.fill(this.ascii, -1);
        this.lazy = false;
        this.ascent = 4;
        this.descent = 4;
        this.glyphCount = 128;
        for (int i = 0; i < 128; ++i) {
            try {
                Constructor<?>[] constructorArray = PFont.Glyph.class.getDeclaredConstructors();
                Constructor<?> constructor = PFont.Glyph.class.getDeclaredConstructors()[0];
                constructor.setAccessible(true);
                for (Constructor<?> constructor2 : constructorArray) {
                    constructor2.setAccessible(true);
                    if (constructor2.getParameterTypes().length != 1) continue;
                    this.glyphs[i] = (PFont.Glyph)constructor2.newInstance(new Object[]{this});
                    break;
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            this.glyphs[i].value = i;
            if (this.glyphs[i].value < 128) {
                this.ascii[this.glyphs[i].value] = i;
            }
            this.glyphs[i].index = i;
            int n = i - 32;
            if (n >= 0) {
                this.glyphs[i].image = new PImage(this.charWidth[n], 9, 4);
                for (int j = 0; j < this.chars[n].length; ++j) {
                    this.glyphs[i].image.pixels[j] = this.chars[n][j] == 1 ? -1 : 0;
                }
                this.glyphs[i].height = 9;
                this.glyphs[i].width = this.charWidth[n];
                this.glyphs[i].index = i;
                this.glyphs[i].value = i;
                this.glyphs[i].setWidth = this.charWidth[n];
                this.glyphs[i].topExtent = 4;
                this.glyphs[i].leftExtent = 0;
                continue;
            }
            this.glyphs[i].image = new PImage(1, 1);
        }
    }

    public PFont.Glyph getGlyph(char c) {
        return this.glyphs[c];
    }

    PImage decodeBitFont(byte[] byArray) {
        int n;
        int n2;
        int n3;
        int n4 = CP.byteArrayToInt(new byte[]{byArray[0], byArray[1]});
        int n5 = CP.byteArrayToInt(new byte[]{byArray[2], byArray[3]});
        int n6 = CP.byteArrayToInt(new byte[]{byArray[4], byArray[5]});
        int n7 = CP.byteArrayToInt(new byte[]{byArray[6], byArray[7]});
        PImage pImage = new PImage(n4, n5, 4);
        for (n3 = n2 = 8 + n6; n3 < byArray.length; ++n3) {
            for (n = 0; n < 8; ++n) {
                pImage.pixels[(n3 - n2) * 8 + n] = CP.getBit(byArray[n3], n) == 1 ? -16777216 : -1;
            }
        }
        n3 = 0;
        n = 0;
        int n8 = 0;
        for (n8 = 0; n8 < n6; ++n8) {
            while (++n3 != byArray[n8 + 8]) {
            }
            pImage.pixels[n += n3] = -65536;
            n3 = 0;
        }
        return pImage;
    }

    int getHeight() {
        return this.texture.height;
    }

    BitFont make() {
        int n;
        this.lineHeight = this.charHeight = this.texture.height;
        int n2 = 0;
        for (n = 0; n < this.texture.width; ++n) {
            ++n2;
            if (this.texture.pixels[n] != -65536) continue;
            this.charWidth[this.characters++] = n2;
            n2 = 0;
        }
        this.chars = new int[this.characters][];
        n = 0;
        for (int i = 0; i < this.characters; ++i) {
            this.chars[i] = new int[this.charWidth[i] * this.charHeight];
            for (int j = 0; j < this.charWidth[i] * this.charHeight; ++j) {
                this.chars[i][j] = this.texture.pixels[n + j / this.charWidth[i] * this.texture.width + j % this.charWidth[i]] == -16777216 ? 1 : 0;
            }
            n += this.charWidth[i];
        }
        return this;
    }
}

