/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import processing.core.PApplet;
import processing.core.PImage;

public class ControllerSprite
implements Cloneable {
    protected PImage sprite;
    protected PImage display;
    protected PImage mask;
    protected int offsetX;
    protected int offsetY;
    protected int width;
    protected int height;
    protected int wh;
    protected boolean isMask;
    protected int _myState;
    protected int _forceState = 0;
    protected int _totalStates = 2;

    public ControllerSprite(ControlP5 controlP5, PImage pImage, int n, int n2) {
        this.sprite = pImage;
        this.width = n;
        this.height = n2;
        this.wh = this.width * this.height;
        this._myState = 0;
        this.display = new PImage(n, n2);
        this.display = ControlP5.papplet.createImage(n, n2, 1);
        this.update();
    }

    public ControllerSprite(ControlP5 controlP5, PImage pImage, int n, int n2, int n3) {
        this.sprite = pImage;
        this.width = n;
        this.height = n2;
        this.wh = this.width * this.height;
        this._myState = 0;
        this._totalStates = --n3 >= 0 ? n3 : 0;
        this.display = new PImage(n, n2);
        this.display = ControlP5.papplet.createImage(n, n2, 1);
        this.update();
    }

    public void draw(PApplet pApplet) {
        pApplet.pushStyle();
        pApplet.imageMode(0);
        if (this.isMask) {
            this.display.mask(this.mask);
        }
        pApplet.image(this.display, 0.0f, 0.0f);
        pApplet.popStyle();
    }

    public void update() {
        int n;
        int n2 = n = this._forceState > 0 ? this._forceState : this._myState;
        if (n > this._totalStates) {
            n = this._totalStates;
        }
        this.display.loadPixels();
        System.arraycopy(this.sprite.pixels, this.wh * n, this.display.pixels, 0, this.wh);
        this.display.updatePixels();
    }

    public void setTotalStates(int n) {
        this._totalStates = --n >= 0 ? n : 0;
    }

    public void setForceState(int n) {
        this._forceState = n;
        this.offsetY = this.height * this._forceState;
        this.update();
    }

    public int getStateCount() {
        return this._totalStates;
    }

    public void setOffset(int n, int n2) {
        this.offsetX = n;
        this.offsetY = n2;
        this.update();
    }

    public void setState(int n) {
        if (n != this._myState) {
            this._myState = n;
            this.offsetY = this.height * this._myState;
            this.update();
        }
    }

    public int getState() {
        return this._myState;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public void setMask(PImage pImage) {
        this.mask = pImage;
    }

    public void enableMask() {
        this.isMask = true;
    }

    public void disableMask() {
        this.isMask = true;
    }

    public ControllerSprite clone() {
        try {
            ControllerSprite controllerSprite = (ControllerSprite)super.clone();
            controllerSprite.sprite = (PImage)this.sprite.clone();
            controllerSprite.display = (PImage)this.display.clone();
            controllerSprite.mask = (PImage)this.mask.clone();
            return controllerSprite;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }
}

