/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControllerInterface;

public class CColor {
    protected int colorBackground = -16763310;
    protected int colorForeground = -16750196;
    protected int colorActive = -16211249;
    protected int colorCaptionLabel = -1;
    protected int colorValueLabel = -1;
    protected int colorBackgroundAlpha = 255;
    protected int colorForegroundAlpha = 255;
    protected int colorActiveAlpha = 255;
    protected int colorCaptionLabelAlpha = 255;
    protected int colorValueLabelAlpha = 255;
    protected int alpha = 255;
    protected int maskA = 0xFFFFFF;
    protected int maskR = -16711681;
    protected int maskG = -65281;
    protected int maskB = -256;

    protected void set(CColor cColor) {
        this.colorBackground = cColor.colorBackground;
        this.colorForeground = cColor.colorForeground;
        this.colorActive = cColor.colorActive;
        this.colorCaptionLabel = cColor.colorCaptionLabel;
        this.colorValueLabel = cColor.colorValueLabel;
        this.colorBackgroundAlpha = cColor.colorBackgroundAlpha;
        this.colorForegroundAlpha = cColor.colorForegroundAlpha;
        this.colorActiveAlpha = cColor.colorActiveAlpha;
        this.colorCaptionLabelAlpha = cColor.colorCaptionLabelAlpha;
        this.colorValueLabelAlpha = cColor.colorValueLabelAlpha;
    }

    protected void copyTo(ControllerInterface controllerInterface) {
        controllerInterface.setColorBackground(this.colorBackground);
        controllerInterface.setColorForeground(this.colorForeground);
        controllerInterface.setColorActive(this.colorActive);
        controllerInterface.setColorLabel(this.colorCaptionLabel);
    }

    public String toString() {
        return "bg (" + (this.colorBackground >> 16 & 0xFF) + "," + (this.colorBackground >> 8 & 0xFF) + "," + (this.colorBackground >> 0 & 0xFF) + "), " + "fg (" + (this.colorForeground >> 16 & 0xFF) + "," + (this.colorForeground >> 8 & 0xFF) + "," + (this.colorForeground >> 0 & 0xFF) + "), " + "active (" + (this.colorActive >> 16 & 0xFF) + "," + (this.colorActive >> 8 & 0xFF) + "," + (this.colorActive >> 0 & 0xFF) + "), " + "captionlabel (" + (this.colorCaptionLabel >> 16 & 0xFF) + "," + (this.colorCaptionLabel >> 8 & 0xFF) + "," + (this.colorCaptionLabel >> 0 & 0xFF) + "), " + "valuelabel " + (this.colorValueLabel >> 16 & 0xFF) + "," + (this.colorValueLabel >> 8 & 0xFF) + "," + (this.colorValueLabel >> 0 & 0xFF) + ")";
    }

    public CColor() {
    }

    public CColor(CColor cColor) {
        this.set(cColor);
    }

    public boolean equals(CColor cColor) {
        return this.colorBackground == cColor.colorBackground && this.colorForeground == cColor.colorForeground && this.colorActive == cColor.colorActive && this.colorCaptionLabel == cColor.colorCaptionLabel && this.colorValueLabel == cColor.colorValueLabel;
    }

    public void setAlpha(int n) {
        this.alpha = n;
        this.colorBackground = this.colorBackground & this.maskA | (int)((float)this.colorBackgroundAlpha * ((float)this.alpha / 255.0f)) << 24;
        this.colorForeground = this.colorForeground & this.maskA | (int)((float)this.colorForegroundAlpha * ((float)this.alpha / 255.0f)) << 24;
        this.colorActive = this.colorActive & this.maskA | (int)((float)this.colorActiveAlpha * ((float)this.alpha / 255.0f)) << 24;
        this.colorCaptionLabel = this.colorCaptionLabel & this.maskA | (int)((float)this.colorCaptionLabelAlpha * ((float)this.alpha / 255.0f)) << 24;
        this.colorValueLabel = this.colorValueLabel & this.maskA | (int)((float)this.colorValueLabel * ((float)this.alpha / 255.0f)) << 24;
    }

    public void setForeground(int n) {
        this.colorForegroundAlpha = n >> 24 & 0xFF;
        this.colorForeground = n & this.maskA | (this.colorForegroundAlpha & this.alpha) << 24;
    }

    public void setBackground(int n) {
        this.colorBackgroundAlpha = n >> 24 & 0xFF;
        this.colorBackground = n & this.maskA | (this.colorBackgroundAlpha & this.alpha) << 24;
    }

    public void setActive(int n) {
        this.colorActiveAlpha = n >> 24 & 0xFF;
        this.colorActive = n & this.maskA | (this.colorActiveAlpha & this.alpha) << 24;
    }

    public void setCaptionLabel(int n) {
        this.colorCaptionLabelAlpha = n >> 24 & 0xFF;
        this.colorCaptionLabel = n & this.maskA | (this.colorCaptionLabelAlpha & this.alpha) << 24;
    }

    public void setValueLabel(int n) {
        this.colorValueLabelAlpha = n >> 24 & 0xFF;
        this.colorValueLabel = n & this.maskA | (this.colorValueLabelAlpha & this.alpha) << 24;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getForeground() {
        return this.colorForeground;
    }

    public int getBackground() {
        return this.colorBackground;
    }

    public int getActive() {
        return this.colorActive;
    }

    public int getCaptionLabel() {
        return this.colorCaptionLabel;
    }

    public int getValueLabel() {
        return this.colorValueLabel;
    }
}

