/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerDisplay;
import controlP5.ControllerGroup;
import controlP5.Label;
import controlP5.TickMark;
import java.util.ArrayList;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slider
extends Controller {
    private int _myDirection;
    public static final int FIX = 1;
    public static final int FLEXIBLE = 0;
    protected int _mySliderMode = 1;
    protected float _myValuePosition;
    protected float _mySliderbarSize = 0.0f;
    protected ArrayList<TickMark> _myTickMarks;
    protected boolean isShowTickMarks;
    protected boolean isSnapToTickMarks;
    protected static int autoWidth = 150;
    protected static int autoHeight = 10;
    protected int alignValueLabel = 3;
    public int valueLabelPositioning = 1;

    public Slider(ControlP5 controlP5, ControllerGroup controllerGroup, String string, float f, float f2, float f3, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, n4);
        this._myCaptionLabel = new Label(string, this.color.colorCaptionLabel);
        this._myMin = f;
        this._myMax = f2;
        this._myValueLabel = new Label("" + (this.adjustValue(this._myMax).length() > this.adjustValue(this._myMin).length() ? this.adjustValue(this._myMax) : this.adjustValue(this._myMin)), this.color.colorValueLabel);
        this._myValueLabel.set("" + this.adjustValue(this._myValue));
        this._myValue = f3;
        this._myTickMarks = new ArrayList();
        this.setSliderMode(1);
        int n5 = this._myDirection = this.width > this.height ? 0 : 1;
        if (this._myDirection == 0) {
            this.alignValueLabel = 3;
            this.valueLabelPositioning = 1;
        } else {
            this.valueLabelPositioning = 0;
        }
        this.valueLabel();
    }

    public void setSliderMode(int n) {
        this._mySliderMode = n;
        this._mySliderbarSize = this._mySliderMode == 0 ? 10.0f : 0.0f;
        this._myUnit = (this._myMax - this._myMin) / (this.width > this.height ? (float)this.width - this._mySliderbarSize : (float)this.height - this._mySliderbarSize);
        this.setValue(this._myValue);
    }

    @Override
    public void updateInternalEvents(PApplet pApplet) {
        if (this.isVisible && this.isMousePressed && !ControlP5.keyHandler.isAltDown) {
            if (this._myDirection == 0) {
                this.setValue(this._myMin + ((float)this._myControlWindow.mouseX - (this._myParent.absolutePosition().x() + this.position.x)) * this._myUnit);
            } else {
                this.setValue(this._myMin + -((float)this._myControlWindow.mouseY - (this._myParent.absolutePosition().y() + this.position.y) - (float)this.height) * this._myUnit);
            }
        }
    }

    protected void snapValue(float f) {
        if (this.isSnapToTickMarks) {
            this._myValuePosition = (this._myValue - this._myMin) / this._myUnit;
            float f2 = PApplet.round((float)PApplet.map((float)this._myValuePosition, (float)0.0f, (float)(this._myDirection == 0 ? (float)this.getWidth() : (float)this.getHeight()), (float)0.0f, (float)(this._myTickMarks.size() - 1)));
            this._myValue = PApplet.map((float)f2, (float)0.0f, (float)(this._myTickMarks.size() - 1), (float)this._myMin, (float)this._myMax);
        }
    }

    @Override
    public void setValue(float f) {
        this._myValue = f;
        this.snapValue(this._myValue);
        this._myValue = this._myValue <= this._myMin ? this._myMin : this._myValue;
        this._myValue = this._myValue >= this._myMax ? this._myMax : this._myValue;
        this._myValuePosition = (this._myValue - this._myMin) / this._myUnit;
        this._myValueLabel.set(this.adjustValue(this._myValue));
        this.broadcast(1);
    }

    @Override
    public void update() {
        this.setValue(this._myValue);
    }

    @Override
    public void setMin(float f) {
        this._myMin = f;
        this.setSliderMode(this._mySliderMode);
    }

    @Override
    public void setMax(float f) {
        this._myMax = f;
        this.setSliderMode(this._mySliderMode);
    }

    @Override
    public Controller setWidth(int n) {
        this.width = n;
        this.setSliderMode(this._mySliderMode);
        return this;
    }

    @Override
    public Controller setHeight(int n) {
        this.height = n;
        this.setSliderMode(this._mySliderMode);
        return this;
    }

    @Override
    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setAttribute("type", "slider");
        controlP5XMLElement.setAttribute("min", new Float(this.min()));
        controlP5XMLElement.setAttribute("max", new Float(this.max()));
    }

    @Override
    public void onEnter() {
    }

    @Override
    public void onLeave() {
    }

    protected void setTickMarks() {
    }

    public void setNumberOfTickMarks(int n) {
        int n2 = n - this._myTickMarks.size();
        if (n2 <= n) {
            for (int i = 0; i < n2; ++i) {
                this._myTickMarks.add(new TickMark(this));
            }
        }
        this.showTickMarks(true);
        this.snapToTickMarks(true);
        this.setValue(this._myValue);
    }

    public int getNumberOfTickMarks() {
        return this._myTickMarks.size();
    }

    public void showTickMarks(boolean bl) {
        this.isShowTickMarks = bl;
    }

    public void snapToTickMarks(boolean bl) {
        this.isSnapToTickMarks = bl;
    }

    public TickMark getTickMark(int n) {
        if (n >= 0 && n < this._myTickMarks.size()) {
            return this._myTickMarks.get(n);
        }
        return null;
    }

    public ArrayList<TickMark> getTickMarks() {
        return this._myTickMarks;
    }

    public void alignValueLabel(int n) {
        this.alignValueLabel = n;
    }

    @Override
    public Controller linebreak() {
        this.controlP5.linebreak(this, true, autoWidth, autoHeight, this.autoSpacing);
        return this;
    }

    @Override
    public void updateDisplayMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myDisplay = new SliderDisplay();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    class SliderDisplay
    implements ControllerDisplay {
        SliderDisplay() {
        }

        public void display(PApplet pApplet, Controller controller) {
            pApplet.fill(Slider.this.color.colorBackground);
            pApplet.noStroke();
            pApplet.rect(0.0f, 0.0f, (float)Slider.this.width, (float)Slider.this.height);
            pApplet.fill(Slider.this.getIsInside() ? Slider.this.color.colorActive : Slider.this.color.colorForeground);
            if (Slider.this._myDirection == 0) {
                if (Slider.this._mySliderMode == 1) {
                    pApplet.rect(0.0f, 0.0f, Slider.this._myValuePosition, (float)Slider.this.height);
                } else if (Slider.this.isShowTickMarks) {
                    pApplet.triangle(Slider.this._myValuePosition, 0.0f, Slider.this._myValuePosition + Slider.this._mySliderbarSize, 0.0f, Slider.this._myValuePosition + Slider.this._mySliderbarSize / 2.0f, (float)Slider.this.height);
                } else {
                    pApplet.rect(Slider.this._myValuePosition, 0.0f, Slider.this._mySliderbarSize, (float)Slider.this.height);
                }
            } else if (Slider.this._mySliderMode == 1) {
                pApplet.rect(0.0f, (float)Slider.this.height, (float)Slider.this.width, -Slider.this._myValuePosition);
            } else if (Slider.this.isShowTickMarks) {
                pApplet.triangle((float)Slider.this.width, (float)Slider.this.height - Slider.this._myValuePosition, (float)Slider.this.width, (float)Slider.this.height - Slider.this._myValuePosition - Slider.this._mySliderbarSize, 0.0f, (float)Slider.this.height - Slider.this._myValuePosition - Slider.this._mySliderbarSize / 2.0f);
            } else {
                pApplet.rect(0.0f, (float)Slider.this.height - Slider.this._myValuePosition - Slider.this._mySliderbarSize, (float)Slider.this.width, Slider.this._mySliderbarSize);
            }
            if (Slider.this.isLabelVisible) {
                int n = 0;
                int n2 = 0;
                if (Slider.this._myDirection == 0) {
                    Slider.this._myCaptionLabel.draw(pApplet, Slider.this.width + 3, Slider.this.height / 2 - 3);
                    switch (Slider.this.alignValueLabel) {
                        case 1: {
                            n = -10;
                            break;
                        }
                        default: {
                            n = Slider.this.height / 2 - 3;
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n = Slider.this.height + 3;
                        }
                    }
                    Slider.this._myValueLabel.draw(pApplet, Slider.this.valueLabelPositioning == 1 ? n2 : (int)Slider.this._myValuePosition, n);
                } else {
                    Slider.this._myCaptionLabel.draw(pApplet, 0, Slider.this.height + 3);
                    switch (Slider.this.alignValueLabel) {
                        default: {
                            n = -10;
                            break;
                        }
                        case 3: {
                            n = Slider.this.height / 2 - 3;
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n = Slider.this.height + 3;
                        }
                    }
                    Slider.this._myValueLabel.draw(pApplet, Slider.this.valueLabelPositioning == 1 ? 0 : Slider.this.width + 4, Slider.this.valueLabelPositioning == 1 ? n : -((int)Slider.this._myValuePosition) + Slider.this.height - 8);
                }
            }
            if (Slider.this.isShowTickMarks) {
                float f;
                pApplet.pushStyle();
                pApplet.pushMatrix();
                float f2 = f = Slider.this._myDirection == 0 ? (float)Slider.this.getWidth() : (float)Slider.this.getHeight();
                if (Slider.this._myDirection == 0) {
                    pApplet.translate(Slider.this._mySliderMode == 1 ? 0.0f : Slider.this._mySliderbarSize / 2.0f, (float)Slider.this.getHeight());
                } else {
                    pApplet.translate(-4.0f, Slider.this._mySliderMode == 1 ? 0.0f : Slider.this._mySliderbarSize / 2.0f);
                }
                float f3 = (f - (Slider.this._mySliderMode == 1 ? 0.0f : Slider.this._mySliderbarSize)) / (float)(Slider.this._myTickMarks.size() - 1);
                for (TickMark tickMark : Slider.this._myTickMarks) {
                    tickMark.draw(pApplet, Slider.this._myDirection);
                    if (Slider.this._myDirection == 0) {
                        pApplet.translate(f3, 0.0f);
                        continue;
                    }
                    pApplet.translate(0.0f, f3);
                }
                pApplet.popMatrix();
                pApplet.popStyle();
            }
        }
    }
}

