/* GameShield Aug 2014 - Ralf Stoffels
 * 
 * The Library supports two 5x8 (resulting in 10 x 8) dot matrix LED displays
 * Simple Game Graphics can be programmed just like on a PC in Processing.
 *
 * The drawings of the required hardware can be found at http://surasto.de
 * 
 * How to instatiate an object in the constructor of an object is described here: 
 * http://arduino.cc/forum/index.php/topic,41519.0.html 
*/

#include <GameShield.h>
#include "Arduino.h"

GameShield::GameShield() {    // Constructor
  int i;   
  xSize = X_SIZE;
  ySize = Y_SIZE;
  for (i=0; i<8; i++) {    // Row drivers to High
    pinMode(i, OUTPUT);
    digitalWrite(i,HIGH);
  }
  for (i=8; i<14; i++) {   // Column drivers (Transistors) to LOW;
    pinMode(i,OUTPUT);
    digitalWrite(i,LOW);
  }
  pinMode(A0,OUTPUT);     // Column drivers (Transistors) to LOW;
  digitalWrite(i,LOW);
  pinMode(A1,OUTPUT);
  digitalWrite(i,LOW);
  pinMode(A2,OUTPUT);
  digitalWrite(i,LOW);
  pinMode(A3,OUTPUT);
  digitalWrite(i,LOW);
  
  pinMode(A4, INPUT);    // Two pins for analog controls
  pinMode(A5, INPUT);
  
  clear();
  rowCounter = 0; 
}

void GameShield::clear(){
  int i,j;
  for (i=0; i<X_SIZE; i++) 
    for (j=0; j<Y_SIZE; j++) canvas[i][j] = false;
}

void GameShield::update() {
  if (rowCounter>0) digitalWrite(rowCounter-1,LOW);   // Clear previous row
  else digitalWrite(Y_SIZE-1, LOW);
	for (int i=0; i<X_SIZE; i++) {
    if (i<6) { 
		  if (canvas[i][rowCounter] == true) digitalWrite(i+8, LOW);   //Column 1...6
      else digitalWrite(i+8, HIGH);
    } else {
      switch (i) {
      case 6:
  		  if (canvas[i][rowCounter] == true) digitalWrite(A0, LOW);   //Column 7
        else digitalWrite(A0, HIGH);        
        break;
      case 7:
  		  if (canvas[i][rowCounter] == true) digitalWrite(A1, LOW);   //Column 8
        else digitalWrite(A1, HIGH);        
        break;
      case 8:
  		  if (canvas[i][rowCounter] == true) digitalWrite(A2, LOW);   //Column 9
        else digitalWrite(A2, HIGH);        
        break;
      case 9:
  		  if (canvas[i][rowCounter] == true) digitalWrite(A3, LOW);   //Column 10
        else digitalWrite(A3, HIGH);        
        break;
      }
    }
  }
	digitalWrite(rowCounter,HIGH);     // set current Row 
  rowCounter++;
  if (rowCounter>=Y_SIZE) rowCounter=0;
  delay(2);
}

void GameShield::point(int x, int y, bool visible) {
  if ((x>=0) && (x<X_SIZE) && (y>=0) && (y<Y_SIZE)) canvas[x][y]=visible;
}

int GameShield::getKnob() {
  return(analogRead(A4));
}

bool GameShield::buttonPressed() {
  if (digitalRead(A5) == LOW) return(true);
  return(false);
}
