// Ein einfaches Spiel zum Ausprobieren der GameShield Library

#include <GameShield.h> 

GameShield screen;

int x,y;
int xdir=1, ydir=1;
int xctrl;
unsigned long lastMillis=0;
boolean spielende=true;
int xpos=0;

void setup() {
  screen.clear();
  x=random(0,9);
  y=0;
}

void loop() {
   
   if (spielende) {
     if (millis() > lastMillis+200) {
       screen.clear();
       drawLeftArrow(xpos,6);
       if (xpos == 0) xpos = 1; else xpos = 0;
       lastMillis = millis();
     }
     if (screen.buttonPressed()) {
       spielende=false;
       screen.clear();
       x=random(0,9);
       y=0;
     }
   } else {
     if (millis()>lastMillis+150) {  
      screen.point(x,y,false);   // Punkt an vorheriger Position löschen
      x += xdir;
      y += ydir;

      screen.point(xctrl-1,7,false);   // gesteuerte Punkte löschen
      screen.point(xctrl,7,false);   
      screen.point(xctrl+1,7,false);  
      xctrl = screen.getKnob()/100;   // Knob solle von 0..1023 gehen
      screen.point(xctrl-1,7,true);     // Punkte entsprechend der Potiposition setzen  
      screen.point(xctrl,7,true);     
      screen.point(xctrl+1,7,true);    
      screen.point(x,y,true);   // Punkt an neuer Position setzen
      lastMillis = millis();

      if (x == X_SIZE-1) xdir=-1;  // Bei Wandberührung apprallen
      if (x == 0) xdir=1;
      if (y == 0) ydir = 1;

      if (y == Y_SIZE-2) {    // Schläger getroffen? 
        if ((x>xctrl-2) && (x<xctrl+2)) ydir = -1;
        else {
          spielende=true;
          screen.beep(2,100);
        }
      }

    }
  } 
  screen.update();
}

void drawLeftArrow(int x, int y) {
  screen.point(x,y,true);
  screen.point(x+1,y-1,true);
  screen.point(x+1,y+1,true);
  screen.point(x+1,y,true);
  screen.point(x+2,y,true);
  screen.point(x+3,y,true);
  screen.point(x+4,y,true);
}
