/**********************************************************************
 *    Display for "Fledermaussensor" with ILO9486 480x320px TFT LCD
 *    
 *    (C) 2021  surasto.de
 **********************************************************************/

#include <LCDWIKI_GUI.h> //Core graphics library
#include <LCDWIKI_KBV.h> //Hardware-specific library

LCDWIKI_KBV lcd(ILI9486,A3,A2,A1,A0,A4); //model,cs,cd,wr,rd,reset

//define some colour values
#define BLACK   0x0000
#define BLUE    0x001F
#define RED     0xF800
#define GREEN   0x07E0
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0
#define WHITE   0xFFFF

//------- Display Size Specific Settings ---------------
#define XSIZE 480
#define YSIZE 320
#define BUTTON 12

//------- Signal Specific Settings --------------------
#define MAXAMPLITUDE 100
#define FGRID 10000.0     // Delta between two lines in HZ
#define AMPGRID 10   // Gridwidth for Amplitudes
#define BIN_INCR 122.0703     // DeltaFrequency in Hz between two bins received (125.000Hz / 1024)
#define HZ_PER_PIXEL 244.1406    // Delta frequency between two horizontal pixels

//----------- Global Variables ----------------------
int lastFreq;   //stores the frequency of the last bin received through Serial
int lastData;   // stores the last y-Value received
String data;

void setup() {
   lcd.Init_LCD();
   lcd.Set_Rotation(1);
   lcd.Fill_Screen(BLACK);
   lcd.Set_Draw_color(GREEN);
   
   lcd.Draw_Rectangle(20,130,460,200);  

   lcd.Set_Text_colour(WHITE);
   lcd.Set_Text_Back_colour(BLACK);
   lcd.Set_Text_Size(3);
   lcd.Print_String("Fledermaus-Scanner v1.0", 30, 140); 
   lcd.Print_String("Surasto.de (C)2021",80,170); 

   lcd.Set_Draw_color(YELLOW);

   delay(3000);

   clearScreen();
 
//--------------- Initializing the communication ---------------
   Serial.begin(19200);
   pinMode(BUTTON, INPUT_PULLUP);
   lastFreq = 0;
   lastData = 0;
}

void loop() {
  int inByte;
  int yValue;
  int freq;

  lcd.Set_Draw_color(GREEN);

  while (Serial.available()>0) {
     inByte = Serial.read();
     if (inByte != '\n') {
        if (inByte>32) data = data + (char) inByte;
     } else {
       yValue = data.toInt();
       Serial.println(yValue);
       if (yValue > 1024) {    // 32000 indicates end of spectrum
          lastFreq = 0;
          lastData = 0;
       } else {
          freq = lastFreq + 1;
          lcd.Draw_Line(lastFreq, YSIZE-YSIZE/40-10-lastData, freq, YSIZE-YSIZE/40-10-yValue*5); 
          lastFreq=freq;
          lastData=yValue;
       } 
       data="";
     }

     if (digitalRead(BUTTON) == LOW) {
       clearScreen();
     }
  }
}

void clearScreen() {
  char scaleText[5];
   
   lcd.Set_Text_Size(1);
   lcd.Fill_Screen(BLACK);
   lcd.Print_String("Fledermaus-Scanner v1.0  -  surasto.de  (C) 2021", 60, YSIZE/40); 

   lcd.Set_Draw_color(RED);
   int f=0;
   int xint;


//------------ Drawing the Grid ----------------------------------
   for (float x=0; x<XSIZE; x+=FGRID/HZ_PER_PIXEL) {
      xint = (int) x;
      lcd.Draw_Line(xint,YSIZE/20,xint,YSIZE);
      sprintf(scaleText, "%dk", f);
      lcd.Print_String(scaleText, xint+5,YSIZE-YSIZE/40);
      f+=(int) FGRID/1000;
   }
   lcd.Draw_Line(0,YSIZE-YSIZE/20,XSIZE,YSIZE-YSIZE/20);
}
